/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.rights;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.ametys.core.right.RightAssignmentContext;
import org.ametys.plugins.core.impl.right.StringRightAssignmentContext;
import org.ametys.plugins.extraction.execution.Extraction;

/**
 * {@link RightAssignmentContext} for assign rights to a {@link Extraction}
 */
public class ExtractionRightAssignmentContext extends StringRightAssignmentContext
{
    @Override
    public Set<Object> getParentContexts(Object context)
    {
        Set<Object> parents = new HashSet<>();
        if (context instanceof String && !context.equals(ExtractionAccessController.ROOT_CONTEXT))
        {
            String contextString = (String) context;
            String parent = contextString.substring(0, contextString.lastIndexOf('/'));
            parents.add(parent);
        }
        return parents;
    }

    @Override
    public List<Object> getRootContexts(Map<String, Object> contextParameters)
    {
        List<Object> rootContexts = new ArrayList<>();

        rootContexts.add(ExtractionAccessController.ROOT_CONTEXT);
        
        return rootContexts;
    }
}
