/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.GroupSearchContentHelper;
import org.ametys.cms.search.cocoon.GroupSearchContent;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.extraction.component.AbstractSolrExtractionComponent;
import org.ametys.plugins.extraction.execution.ExtractionExecutionContext;
import org.ametys.runtime.model.ViewItemContainer;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public abstract class AbstractGroupExtractionComponent
extends AbstractSolrExtractionComponent {
    protected List<String> _groupingFields = new ArrayList<String>();
    private GroupSearchContentHelper _groupSearchContentHelper;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._groupSearchContentHelper = (GroupSearchContentHelper)serviceManager.lookup(GroupSearchContentHelper.ROLE);
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        String groupingFieldsAsString = configuration.getChild("grouping-fields").getValue("");
        this._groupingFields.addAll(StringUtils.stringToCollection((String)groupingFieldsAsString));
    }

    @Override
    public void prepareComponentExecution(ExtractionExecutionContext context) throws Exception {
        super.prepareComponentExecution(context);
        for (String groupingField : this._groupingFields) {
            this._getAttributeTypeId(groupingField, this._contentTypes);
        }
    }

    protected GroupSearchContent organizeContentsInGroups(Iterable<Content> contents, Locale defaultLocale) {
        Set baseContentTypes = this._contentTypesHelper.getCommonAncestors((Collection)this._contentTypes).stream().map(arg_0 -> ((ContentTypeExtensionPoint)this._contentTypeExtensionPoint).getExtension(arg_0)).collect(Collectors.toSet());
        return this._groupSearchContentHelper.organizeContentsInGroups(contents, this._groupingFields, baseContentTypes, defaultLocale);
    }

    protected void saxGroup(ContentHandler contentHandler, GroupSearchContent group, int level, ExtractionExecutionContext context, ViewItemContainer resultItems) throws Exception {
        if (level > 0) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("level", String.valueOf(level));
            attrs.addCDATAAttribute("fullModelPath", group.getGroupFieldPath());
            attrs.addCDATAAttribute("value", group.getGroupName());
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"group", (Attributes)attrs);
        }
        for (GroupSearchContent groupSearchContent : group.getSubList()) {
            this.saxGroup(contentHandler, groupSearchContent, level + 1, context, resultItems);
        }
        if (!group.getContents().isEmpty() || group.getSubList().isEmpty()) {
            this.saxContents(contentHandler, context, resultItems, group.getContents());
        }
        if (level > 0) {
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"group");
        }
    }

    protected abstract void saxContents(ContentHandler var1, ExtractionExecutionContext var2, ViewItemContainer var3, List<Content> var4) throws Exception;

    @Override
    public Map<String, Object> getComponentDetailsForTree() {
        Map<String, Object> details = super.getComponentDetailsForTree();
        Map data = (Map)details.get("data");
        data.put("groupingFields", String.join((CharSequence)",", this.getGroupingFields()));
        return details;
    }

    public List<String> getGroupingFields() {
        return this._groupingFields;
    }

    public void addGroupingFields(String ... groupingFields) {
        this._groupingFields.addAll(Arrays.asList(groupingFields));
    }
}

