/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.edition;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.cms.repository.ContentDAO;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.extraction.execution.ExtractionDAO;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public class EditExtractionClientSideElement
extends StaticClientSideElement {
    public static final String ROLE = EditExtractionClientSideElement.class.getName();
    private SourceResolver _sourceResolver;
    private ContentWorkflowHelper _contentWorkflowHelper;
    private I18nUtils _i18nUtils;
    private ContentDAO _contentDAO;
    private UserHelper _userHelper;
    private ExtractionDAO _extractionDAO;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._sourceResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)serviceManager.lookup(ContentWorkflowHelper.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
        this._contentDAO = (ContentDAO)serviceManager.lookup(ContentDAO.ROLE);
        this._userHelper = (UserHelper)serviceManager.lookup(UserHelper.ROLE);
        this._extractionDAO = (ExtractionDAO)((Object)serviceManager.lookup(ExtractionDAO.ROLE));
    }

    @Callable(rights={"Extraction_Rights_EditExtraction"})
    public Map<String, Object> createExtraction(String relativeDefinitionFilePath, String language) throws Exception {
        Map<String, Object> map;
        block9: {
            Source definitionsSrc = this._sourceResolver.resolveURI("context://WEB-INF/param/extraction/definitions/");
            File definitionsDir = ((FileSource)definitionsSrc).getFile();
            definitionsDir.mkdirs();
            String absoluteDefinitionFilePath = "context://WEB-INF/param/extraction/definitions/" + relativeDefinitionFilePath;
            Source definitionSrc = this._sourceResolver.resolveURI(absoluteDefinitionFilePath);
            File definitionFile = ((FileSource)definitionSrc).getFile();
            if (definitionFile.exists()) {
                this.getLogger().error("A definition file already exists at path '{}'", (Object)relativeDefinitionFilePath);
                return Map.of("success", false, "error", "already-exists");
            }
            OutputStream os = Files.newOutputStream(Paths.get(definitionFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
            try {
                String extractionName = this._getExtractionNameFromFileName(definitionFile.getName());
                I18nizableText descriptionTitle = new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_CONTENT_DESCRIPTION_DEFAULT_TITLE", Collections.singletonList(extractionName));
                Map contentInfos = this._contentWorkflowHelper.createContent("extraction-description", 1, extractionName, this._i18nUtils.translate((I18nizable)descriptionTitle, language), new String[]{"org.ametys.plugins.extraction.Content.description"}, new String[0], language);
                String descriptionId = (String)contentInfos.get("contentId");
                TransformerHandler handler = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
                StreamResult result = new StreamResult(os);
                handler.setResult(result);
                Properties format = new Properties();
                format.put("method", "xml");
                format.put("indent", "yes");
                format.put("encoding", "UTF-8");
                format.put("{http://xml.apache.org/xalan}indent-amount", "4");
                handler.getTransformer().setOutputProperties(format);
                handler.startDocument();
                XMLUtils.startElement((ContentHandler)handler, (String)"extraction");
                AttributesImpl attributes = new AttributesImpl();
                attributes.addCDATAAttribute("id", descriptionId);
                XMLUtils.createElement((ContentHandler)handler, (String)"description", (Attributes)attributes);
                UserIdentity author = this._currentUserProvider.getUser();
                this._userHelper.saxUserIdentity(author, (ContentHandler)handler, "author");
                XMLUtils.endElement((ContentHandler)handler, (String)"extraction");
                handler.endDocument();
                map = Map.of("success", true, "path", relativeDefinitionFilePath, "name", definitionFile.getName(), "descriptionId", descriptionId, "author", this._userHelper.user2json(author), "canRead", true, "canWrite", true, "canAssignRights", true);
                if (os == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.getLogger().error("Error when trying to create the extraction definition file '{}'", (Object)relativeDefinitionFilePath, (Object)e);
                    return Map.of("success", false, "error", "other-error");
                }
            }
            os.close();
        }
        return map;
    }

    private String _getExtractionNameFromFileName(String fileName) {
        return fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(".")) : fileName;
    }

    @Callable(rights={"Extraction_Rights_EditExtraction"})
    public Map<String, Object> addDescription(String definitionFileName, String descriptionId) throws Exception {
        return this._modifyDefinitionFile(definitionFileName, descriptionId, this::_insertDescriptionInDocument);
    }

    private void _insertDescriptionInDocument(Document document, String descriptionId) {
        Element extractionRoot = document.getDocumentElement();
        this._getElements(document.getDocumentElement(), "description").forEach(extractionRoot::removeChild);
        Element description = document.createElement("description");
        description.setAttribute("id", descriptionId);
        extractionRoot.insertBefore(description, extractionRoot.getFirstChild());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Map<String, Object> _modifyDefinitionFile(String definitionFileName, T dataToModify, BiConsumer<Document, T> modifyingConsumer) throws Exception {
        String definitionFilePath = "context://WEB-INF/param/extraction/definitions/" + definitionFileName;
        Source definitionSrc = this._sourceResolver.resolveURI(definitionFilePath);
        File definitionFile = ((FileSource)definitionSrc).getFile();
        if (!definitionFile.exists()) {
            this.getLogger().error("Error while adding a description to the extraction '{}': this definition file doesn't exist.", (Object)definitionFileName);
            return Map.of("success", false, "error", "unexisting");
        }
        String tmpFilePath = "context://WEB-INF/param/extraction/definitions/" + definitionFileName + ".tmp";
        Source tmpSrc = this._sourceResolver.resolveURI(tmpFilePath);
        File tmpFile = ((FileSource)tmpSrc).getFile();
        try {
            Map<String, Object> map;
            block12: {
                OutputStream os = Files.newOutputStream(Paths.get(tmpFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
                try {
                    Document document = this._parseDefinitionFile(definitionFile);
                    modifyingConsumer.accept(document, (Document)dataToModify);
                    DOMSource source = new DOMSource(document);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    StreamResult result = new StreamResult(os);
                    transformer.transform(source, result);
                    Files.copy(tmpFile.toPath(), definitionFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    map = Map.of("success", true);
                    if (os == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.getLogger().error("Error when trying to modify the extraction '{}'", (Object)definitionFileName, (Object)e);
                        Map<String, Object> map2 = Map.of("success", false, "error", "other-error");
                        return map2;
                    }
                }
                os.close();
            }
            return map;
        }
        finally {
            this._deleteTemporaryFile(definitionFileName, tmpFile.toPath());
        }
    }

    private void _deleteTemporaryFile(String definitionFileName, Path temporaryFilePath) {
        try {
            Files.deleteIfExists(temporaryFilePath);
        }
        catch (IOException e) {
            this.getLogger().error("Error when deleting the temporary file for '{}'", (Object)definitionFileName, (Object)e);
        }
    }

    @Callable(rights={"Extraction_Rights_EditExtraction"})
    public Map<String, Object> renameExtraction(String relativeOldFilePath, String newFileName) throws Exception {
        String fileUri = "context://WEB-INF/param/extraction/definitions/" + relativeOldFilePath;
        FileSource file = (FileSource)this._sourceResolver.resolveURI(fileUri);
        String relativeParentPath = StringUtils.removeEnd((String)relativeOldFilePath, (String)file.getName());
        String relativeNewFilePath = relativeParentPath + newFileName;
        return this._extractionDAO.moveOrRenameExtractionDefinitionFile(relativeOldFilePath, relativeNewFilePath);
    }

    @Callable(rights={"Extraction_Rights_EditExtraction"})
    public boolean deleteExtraction(String definitionFileName) throws Exception {
        String filePath = "context://WEB-INF/param/extraction/definitions/" + definitionFileName;
        Source source = this._sourceResolver.resolveURI(filePath);
        File file = ((FileSource)source).getFile();
        if (!file.exists()) {
            throw new IllegalArgumentException("Error while deleting '" + definitionFileName + "': this definition file doesn't exist.");
        }
        try {
            Document document = this._parseDefinitionFile(file);
            List descriptionIds = this._getElements(document.getDocumentElement(), "description").map(description -> description.getAttribute("id")).collect(Collectors.toList());
            this._contentDAO.deleteContents(descriptionIds, "Extraction_Rights_EditExtraction");
            Files.deleteIfExists(file.toPath());
            String context = "/extraction-dir/" + definitionFileName;
            this._extractionDAO.deleteRights(context);
        }
        catch (IOException e) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Error while deleting definition file '" + definitionFileName + "'.", (Throwable)e);
            }
            throw e;
        }
        return true;
    }

    private Document _parseDefinitionFile(File definitionFile) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(definitionFile);
    }

    private Stream<Element> _getElements(Element extractionRoot, String nodeTagName) {
        NodeList nodeList = extractionRoot.getElementsByTagName(nodeTagName);
        return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item).map(Element.class::cast);
    }
}

