/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.extraction.component.ExtractionComponent;
import org.ametys.plugins.extraction.edition.SaveExtractionHelper;
import org.ametys.plugins.extraction.execution.Extraction;
import org.ametys.plugins.extraction.execution.ExtractionDefinitionReader;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;

public class ExtractionDetailsToolElement
extends StaticClientSideElement {
    private ExtractionDefinitionReader _reader;
    private SourceResolver _sourceResolver;
    private SaveExtractionHelper _saveHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._reader = (ExtractionDefinitionReader)((Object)serviceManager.lookup(ExtractionDefinitionReader.ROLE));
        this._sourceResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._saveHelper = (SaveExtractionHelper)((Object)serviceManager.lookup(SaveExtractionHelper.ROLE));
    }

    @Callable(rights={"Extraction_Rights_ExecuteExtraction"})
    public Map<String, Object> getExtractionDefinitionDetails(String relativeDefinitionFilePath) throws Exception {
        LinkedHashMap<String, Object> extractionDefinitionDetails = new LinkedHashMap<String, Object>();
        String absoluteDefinitionFilePath = "context://WEB-INF/param/extraction/definitions/" + relativeDefinitionFilePath;
        Source src = this._sourceResolver.resolveURI(absoluteDefinitionFilePath);
        File file = ((FileSource)src).getFile();
        if (!file.exists()) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("The file " + relativeDefinitionFilePath + " does not exist.");
            }
            extractionDefinitionDetails.put("success", false);
            extractionDefinitionDetails.put("file-error", "unexisting");
            return extractionDefinitionDetails;
        }
        Extraction extraction = this._reader.readExtractionDefinitionFile(file);
        ArrayList<Map<String, Object>> extractionNodes = new ArrayList<Map<String, Object>>();
        Map<String, Object> clausesVariablesNode = this._getClausesVariablesNode(extraction);
        extractionNodes.add(clausesVariablesNode);
        Map<String, Object> optionalColumnsNode = this._getOptionalColumnsNode(extraction);
        extractionNodes.add(optionalColumnsNode);
        List<Map<String, Object>> componentsNodes = this._getComponentNodes(extraction.getExtractionComponents());
        if (!componentsNodes.isEmpty()) {
            extractionNodes.addAll(componentsNodes);
        }
        extractionDefinitionDetails.put("success", true);
        extractionDefinitionDetails.put("descriptionId", extraction.getDescriptionId());
        extractionDefinitionDetails.put("children", extractionNodes);
        return extractionDefinitionDetails;
    }

    private Map<String, Object> _getClausesVariablesNode(Extraction extraction) {
        LinkedHashMap<String, Object> clausesVariablesNode = new LinkedHashMap<String, Object>();
        List<Extraction.ClausesVariable> clausesVariables = extraction.getClausesVariables();
        ArrayList variables = new ArrayList();
        for (Extraction.ClausesVariable clausesVariable : clausesVariables) {
            LinkedHashMap<String, Object> clausesVariableData = new LinkedHashMap<String, Object>();
            clausesVariableData.put("name", clausesVariable.name());
            clausesVariableData.put("type", clausesVariable.type().getStringValue());
            clausesVariableData.put("contentTypeIds", clausesVariable.contentTypeIds());
            clausesVariable.searchModelId().ifPresent(searchModelId -> clausesVariableData.put("searchModelId", searchModelId));
            clausesVariable.solrRequest().ifPresent(solrRequest -> clausesVariableData.put("solrRequest", solrRequest));
            variables.add(clausesVariableData);
        }
        LinkedHashMap clausesVariablesData = new LinkedHashMap();
        clausesVariablesData.put("variables", variables);
        clausesVariablesNode.put("text", new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_TREE_CLAUSES_VARIABLES_NODE_TEXT"));
        clausesVariablesNode.put("data", clausesVariablesData);
        clausesVariablesNode.put("leaf", true);
        clausesVariablesNode.put("tag", "clauses-variables");
        clausesVariablesNode.put("iconCls", "ametysicon-symbol-x");
        return clausesVariablesNode;
    }

    private Map<String, Object> _getOptionalColumnsNode(Extraction extraction) {
        LinkedHashMap<String, Object> optionalColumnsNode = new LinkedHashMap<String, Object>();
        List<String> optionalColumns = extraction.getDisplayOptionalColumnsNames();
        LinkedHashMap<String, List<String>> optionalColumnsData = new LinkedHashMap<String, List<String>>();
        optionalColumnsData.put("names", optionalColumns);
        optionalColumnsNode.put("text", new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_TREE_OPTIONAL_COLUMNS_NODE_TEXT"));
        optionalColumnsNode.put("data", optionalColumnsData);
        optionalColumnsNode.put("leaf", true);
        optionalColumnsNode.put("tag", "optional-columns");
        optionalColumnsNode.put("iconCls", "ametysicon-table28");
        return optionalColumnsNode;
    }

    private List<Map<String, Object>> _getComponentNodes(List<ExtractionComponent> components) {
        ArrayList<Map<String, Object>> componentNodes = new ArrayList<Map<String, Object>>();
        for (ExtractionComponent component : components) {
            Map<String, Object> componentNode = component.getComponentDetailsForTree();
            if (component.getSubComponents().isEmpty()) {
                componentNode.put("leaf", true);
            } else {
                componentNode.put("children", this._getComponentNodes(component.getSubComponents()));
            }
            componentNodes.add(componentNode);
        }
        return componentNodes;
    }

    @Callable(rights={"Extraction_Rights_EditExtraction"})
    public boolean saveExtraction(String definitionFileName, Map<String, Object> extraction) throws Exception {
        return this._saveHelper.saveExtraction(definitionFileName, extraction);
    }
}

