/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the data model for extraction definition file entries.
 * @private
 */
Ext.define('Ametys.plugins.extraction.execution.ExtractionFileNode', {
    extend: 'Ametys.file.AbstractFileExplorerTree.FileNode',
    
    /**
     * @property {Object} fields Data structure of the extraction definition file entries
     * @property {String} fields.descriptionId Description's identifier of entry
     * @property {Object} fields.author Author of the entry
     * @property {String} fields.author.login the author's login
     * @property {String} fields.author.populationId the author's population identifier
     * @property {Boolean} fields.canRead true if the current user can read the entry
     * @property {Boolean} fields.canWrite true if the current user can write the entry
     * @property {Boolean} fields.canDelete true if the current user can delete the entry
     * @property {Boolean} fields.canAssignRights true if the current user can edit rights of the extraction definition
     * @private
     */
    fields: [
        {name: 'descriptionId'},
        {name: 'author'},
        {
            name: 'authorFullName', 
            type: 'string',
            calculate: function (data) {
                return data.author ? data.author.sortablename: '';
            }
        },
        
        {name: 'canRead', type: 'boolean'},
        {name: 'canWrite', type: 'boolean'},
        {name: 'canDelete', type: 'boolean'},
        {name: 'canAssignRights', type: 'boolean'}
    ]
});