/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.component;

import org.apache.commons.lang3.StringUtils;

/**
 * Object representing a extraction columns
 */
public class ExtractionColumn
{

    private String _fieldPath;
    private String _displayOptionalName;
    
    /**
     * Retrieves the field path
     * @return The field path
     */
    public String getFieldPath()
    {
        return _fieldPath;
    }
    
    /**
     * Set the field path
     * @param fieldPath The field path to set
     */
    public void setFieldPath(String fieldPath)
    {
        _fieldPath = fieldPath;
    }
    
    /**
     * Checks if the extraction column is optional
     * @return true if the column is optional, false otherwise
     */
    public boolean isOptional()
    {
        return !StringUtils.isBlank(_displayOptionalName);
    }
    
    /**
     * Retrieves the name of the variable controlling display of optional column 
     * @return The name of the variable
     */
    public String getDisplayOptionalName()
    {
        return _displayOptionalName;
    }
    
    /**
     * Set the name of the variable controlling the display of optional column
     * @param displayOptionalName The name of the variable 
     */
    public void setDisplayOptionalName(String displayOptionalName)
    {
        _displayOptionalName = displayOptionalName;
    }
}
