/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.execution.pipeline;

import java.io.Closeable;

import org.xml.sax.ContentHandler;

/**
 * A pipeline for extraction execution.
 * <br>Must be {@link #close() closed}.
 */
public interface Pipeline extends Closeable
{
    /**
     * Prepare and gets the {@link ContentHandler} for this pipeline.
     * @return the {@link ContentHandler}
     * @throws Exception if an error occured
     */
    ContentHandler getHandler() throws Exception;
    
    /**
     * Serializes this pipeline.
     * <br>{@link #getHandler()} method must have been called before, and the {@link ContentHandler} must no longer receive any event.
     * <br>Then, the pipeline must be {@link #close() closed}.
     * @throws Exception if an error occured
     */
    void serialize() throws Exception;
}
