/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.execution.pipeline.impl;

import java.io.IOException;
import java.io.OutputStream;

import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;

import org.ametys.plugins.extraction.execution.pipeline.Pipelines;

abstract class AbstractSerializerImpl implements PipelineSerializer
{
    protected TransformerHandler _handler;
    protected OutputStream _out;
    protected StreamResult _streamResult;
    
    AbstractSerializerImpl(TransformerHandler handler, OutputStream out)
    {
        _handler = handler;
        _out = out;
    }
    
    @Override
    public void prepare() throws Exception
    {
        _streamResult = Pipelines.setResult(_handler, _out);
    }

    @Override
    public void close() throws IOException
    {
        Pipelines.close(_streamResult);
    }
}
