/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.generators;

import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.data.Answer;
import org.ametys.plugins.forms.generators.FormDashboardGenerator;
import org.ametys.plugins.forms.helper.FormAdminDashboardHelper;
import org.ametys.plugins.forms.helper.FormMailHelper;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.forms.workflow.FormEntryCurrentStepExpression;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.ametys.plugins.workflow.dao.WorkflowStepDAO;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FormAdminDashboardGenerator
extends FormDashboardGenerator {
    private static int __DEFAULT_NB_ENTRIES_BY_PAGE = 10;
    private static String __DEFAULT_SORT_ORDER = "ascending";
    protected UserManager _userManager;
    protected FormMailHelper _formMailHelper;
    protected FormAdminDashboardHelper _formAdminDashboardHelper;
    protected WorkflowStepDAO _stepDAO;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._formMailHelper = (FormMailHelper)((Object)smanager.lookup(FormMailHelper.ROLE));
        this._formAdminDashboardHelper = (FormAdminDashboardHelper)((Object)smanager.lookup(FormAdminDashboardHelper.ROLE));
        this._stepDAO = (WorkflowStepDAO)smanager.lookup(WorkflowStepDAO.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _saxFormDashboardData(UserIdentity user) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"dashboard");
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            String siteName = WebHelper.getSiteName((Request)request);
            String formId = request.getParameter("formId");
            if (StringUtils.isBlank((CharSequence)formId)) {
                List<Form> forms = this._formAdminDashboardHelper.getFormToAdmin(siteName, user);
                this._saxForms(forms);
            } else {
                this._saxFormEntries(request, formId, user);
            }
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"dashboard");
    }

    protected void _saxForms(List<Form> forms) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"forms");
        for (Form form : forms) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", form.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"form", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)form.getTitle());
            String description = form.getDescription();
            if (description != null) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"description", (String)description);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"form");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"forms");
    }

    protected EntriesRecord _getAvailableFormEntries(String formId, int page, int nbEntriesByPage, String sortOrder, Integer stateId, String submitterId) {
        ArrayList<FormEntry> availableEntries = new ArrayList<FormEntry>();
        Form form = (Form)this._resolver.resolveById(formId);
        Expression filterExpr = this._getFilterExpression(stateId, submitterId);
        List<FormEntry> entries = this._formEntryDAO.getFormEntries(form, false, filterExpr, List.of(new FormEntryDAO.Sort("ametys-id", sortOrder)));
        int activeEntriesSize = entries.size();
        int nbAnswer = 0;
        int lastEntryIndex = page * nbEntriesByPage;
        boolean hasNextPage = false;
        for (int position = 0; nbAnswer <= lastEntryIndex && position < activeEntriesSize; ++position) {
            FormEntry entry = entries.get(position);
            if (!this._formAdminDashboardHelper.hasAvailableActions(entry)) continue;
            if (nbAnswer == lastEntryIndex) {
                hasNextPage = true;
            } else {
                availableEntries.add(entry);
            }
            ++nbAnswer;
        }
        return new EntriesRecord(availableEntries, hasNextPage);
    }

    private Expression _getFilterExpression(Integer stateId, String submitterId) {
        ArrayList<Object> filterExprs = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)submitterId)) {
            filterExprs.add(new UserExpression("ametys-user", Expression.Operator.EQ, submitterId));
        }
        if (stateId != null) {
            filterExprs.add(new FormEntryCurrentStepExpression(stateId));
        }
        return new AndExpression(filterExprs);
    }

    protected void _saxFormEntries(Request request, String formId, UserIdentity user) throws SAXException {
        Form form = (Form)this._resolver.resolveById(formId);
        String stateIdAsString = request.getParameter("workflowFilter");
        Integer stateId = StringUtils.isNotBlank((CharSequence)stateIdAsString) ? Integer.valueOf(Integer.parseInt(stateIdAsString)) : null;
        String submitter = request.getParameter("submitterFilter");
        int nbAnswerByPage = StringUtils.isNotBlank((CharSequence)request.getParameter("nbEntriesByPage")) ? Integer.parseInt(request.getParameter("nbEntriesByPage")) : __DEFAULT_NB_ENTRIES_BY_PAGE;
        int page = request.getParameter("page") != null ? Integer.parseInt(request.getParameter("page")) : 1;
        String sortOrder = StringUtils.isNotBlank((CharSequence)request.getParameter("entriesSortOrder")) ? request.getParameter("entriesSortOrder") : __DEFAULT_SORT_ORDER;
        EntriesRecord availableFormEntries = this._getAvailableFormEntries(formId, page, nbAnswerByPage, sortOrder, stateId, submitter);
        List<FormEntry> entries = availableFormEntries.entries();
        int size = entries.size();
        int mod = size % nbAnswerByPage;
        page = mod == 0 && size != 0 ? size / nbAnswerByPage : size / nbAnswerByPage + 1;
        List<FormEntry> entriesToSax = entries.subList((page - 1) * nbAnswerByPage, Math.min(page * nbAnswerByPage, size));
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("formId", formId);
        attrs.addCDATAAttribute("formTitle", form.getTitle());
        attrs.addCDATAAttribute("page", String.valueOf(page));
        attrs.addCDATAAttribute("hasNextPage", String.valueOf(availableFormEntries.hasNextEntries()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"answers", (Attributes)attrs);
        this._saxFilters(form, stateId, submitter);
        try {
            for (FormEntry entry : entriesToSax) {
                this._saxAnswer(this._formEntry2Answer(entry), user);
            }
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred saxing answers", (Throwable)e);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"answers");
    }

    protected void _saxFilters(Form form, Integer stateId, String submitterId) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"filters");
        this._saxStateFilter(form, stateId);
        this._saxSubmitterFilter(submitterId);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"filters");
    }

    private void _saxStateFilter(Form form, Integer stateId) throws SAXException {
        AttributesImpl workflowAttrs = new AttributesImpl();
        if (stateId != null) {
            workflowAttrs.addCDATAAttribute("value", String.valueOf(stateId));
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"workflow-states", (Attributes)workflowAttrs);
        String workflowName = form.getWorkflowName();
        WorkflowDescriptor workflowDescriptor = this._workflowHelper.getWorkflowDescriptor(workflowName);
        List steps = workflowDescriptor.getSteps();
        for (StepDescriptor step : steps) {
            AttributesImpl stepAttrs = new AttributesImpl();
            int stepId = step.getId();
            stepAttrs.addCDATAAttribute("value", String.valueOf(stepId));
            stepAttrs.addCDATAAttribute("label", this._stepDAO.getStepLabelAsString(workflowDescriptor, stepId, false));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"state", (Attributes)stepAttrs);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"workflow-states");
    }

    private void _saxSubmitterFilter(String submitterId) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        if (StringUtils.isNotBlank((CharSequence)submitterId)) {
            attrs.addCDATAAttribute("value", submitterId);
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"submitters", (Attributes)attrs);
    }

    @Override
    protected void _saxWorkflowInformations(Answer answer, UserIdentity user) throws Exception {
        super._saxWorkflowInformations(answer, user);
        FormEntry formEntry = (FormEntry)this._resolver.resolveById(answer.getId());
        this._saxMailUsersInformations(formEntry, user);
    }

    private void _saxMailUsersInformations(FormEntry formEntry, UserIdentity user) throws SAXException {
        User currentUser = this._userManager.getUser(user);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"sender-mail", (String)currentUser.getEmail());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"sender-fullname", (String)(currentUser.getFullName() + " <" + currentUser.getEmail() + ">"));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"receivers");
        User entryUser = this._userManager.getUser(formEntry.getUser());
        if (entryUser != null) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"receiver");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"receiver-mail", (String)entryUser.getEmail());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"receiver-fullname", (String)(entryUser.getFullName() + " <" + entryUser.getEmail() + ">"));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"receiver");
        }
        for (FormQuestion question : this._formMailHelper.getQuestionWithMail(formEntry.getForm().getId())) {
            Optional<String> receiver = this._formMailHelper.getReceiver(formEntry, Optional.of(question.getNameForForm()));
            if (!receiver.isPresent()) continue;
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"receiver");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"receiver-mail", (String)receiver.get());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"receiver-fullname", (String)(question.getTitle() + " <" + receiver.get() + ">"));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"receiver");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"receivers");
    }

    private record EntriesRecord(List<FormEntry> entries, boolean hasNextEntries) {
    }
}

