/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.generators;

import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.dao.FormQuestionDAO;
import org.ametys.plugins.forms.generators.FormAdminEntryInformationGenerator;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.data.ametysobject.DataAwareAmetysObject;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.model.type.DataContext;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FormFrontEditEntryInformationGenerator
extends FormAdminEntryInformationGenerator {
    protected WorkflowHelper _workflowHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._workflowHelper = (WorkflowHelper)smanager.lookup(WorkflowHelper.ROLE);
    }

    private boolean _isSubmitter() {
        return this.parameters.getParameterAsBoolean("isSubmitter", false);
    }

    @Override
    protected void _checkRights(FormEntry entry) {
        boolean isSubmitter;
        UserIdentity user = this._currentUserProvider.getUser();
        boolean bl = isSubmitter = this._isSubmitter() && entry.getUser().equals((Object)user);
        if (!isSubmitter) {
            super._checkRights(entry);
        }
    }

    @Override
    protected List<FormQuestion> _getQuestions(FormEntry entry, Optional<Long> currentStepId) {
        boolean onlyReadableQuestion = this._isSubmitter();
        return this._formQuestionDAO.getRuleFilteredQuestions(entry.getForm(), new FormQuestionDAO.FormEntryValues(null, entry), currentStepId, false, onlyReadableQuestion);
    }

    @Override
    protected void _saxQuestion(FormQuestion question, FormEntry entry) throws SAXException {
        Long currentStepId = this._formEntryDAO.getCurrentStepId(entry);
        FormQuestionType questionType = question.getType();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("type", questionType.getId());
        attrs.addCDATAAttribute("id", question.getId());
        attrs.addCDATAAttribute("name", question.getNameForForm());
        attrs.addCDATAAttribute("canWrite", String.valueOf(this._isSubmitter() || question.canWrite(currentStepId)));
        attrs.addCDATAAttribute("canRead", "true");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"question", (Attributes)attrs);
        RepositoryDataContext context = RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)question);
        question.dataToSAX(this.contentHandler, (DataContext)context);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"additional-infos");
        questionType.saxAdditionalInfos(this.contentHandler, question);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"additional-infos");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"entry-value");
        questionType.saxEntryValue(this.contentHandler, question, entry);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"entry-value");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"question");
    }

    @Override
    protected void _addAdditionalEntryAttributes(FormEntry entry, AttributesImpl attrs) {
        super._addAdditionalEntryAttributes(entry, attrs);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String actionId = (String)request.get("actionId");
        if (StringUtils.isNotBlank((CharSequence)actionId)) {
            WorkflowDescriptor workflowDescriptor = this._workflowHelper.getWorkflowDescriptor(entry.getForm().getWorkflowName());
            ActionDescriptor action = workflowDescriptor.getAction(Integer.parseInt(actionId));
            Map metaAttributes = action.getMetaAttributes();
            String actionType = (String)metaAttributes.get("action-type");
            if (StringUtils.isNotBlank((CharSequence)actionType)) {
                attrs.addCDATAAttribute("actionType", actionType);
            }
            attrs.addCDATAAttribute("actionId", actionId);
        }
    }
}

