/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.apache.commons.io.IOUtils;

public class FormQuestionTypeExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<FormQuestionType> {
    public static final String ROLE = FormQuestionTypeExtensionPoint.class.getName();
    private String _questions2htmlXSLT;

    public String getQuestions2htmlXSLT() {
        return this._questions2htmlXSLT;
    }

    public void initializeExtensions() throws Exception {
        String template = this._readTemplate();
        Set<String> questions2htmlXSLTs = this._getDocbook2htmlXSLTs();
        String questions2htmlXSLTsIncludes = this._createIncludes(questions2htmlXSLTs);
        this._questions2htmlXSLT = template.replace("@INCLUDE@", questions2htmlXSLTsIncludes);
    }

    private String _readTemplate() throws IOException {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("template.xsl");){
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
    }

    private String _createIncludes(Set<String> includes) {
        StringBuffer sb = new StringBuffer("");
        for (String file : includes) {
            sb.append("<xsl:include href=\"");
            sb.append(file);
            sb.append("\"/>");
        }
        return sb.toString();
    }

    private Set<String> _getDocbook2htmlXSLTs() {
        HashSet<String> question2htmlXSLTs = new HashSet<String>();
        for (String id : this.getExtensionsIds()) {
            FormQuestionType formQuestionType = (FormQuestionType)this.getExtension(id);
            question2htmlXSLTs.add(formQuestionType.getDisplayXSLT());
        }
        return question2htmlXSLTs;
    }
}

