/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.types;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.core.ui.util.ConfigurationHelper;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.question.FormQuestionDataTypeExtensionPoint;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.validators.NameForFormValidator;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.data.ametysobject.DataAwareAmetysObject;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefaultElementDefinition;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.ModelViewItemGroup;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemGroup;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractStaticFormQuestionType
extends AbstractLogEnabled
implements FormQuestionType,
Configurable,
PluginAware,
Serviceable {
    protected I18nUtils _i18nUtils;
    protected String _id;
    protected I18nizableText _label;
    protected I18nizableText _description;
    protected String _iconGlyph;
    protected String _pluginName;
    protected List<ClientSideElement.ScriptFile> _scripts;
    protected String _xslt;
    protected Model _formQuestionModel;
    protected I18nizableText _category;
    protected Integer _priority;

    public void service(ServiceManager manager) throws ServiceException {
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._id = configuration.getAttribute("id");
        Configuration childLabel = configuration.getChild("label");
        this._label = I18nizableText.getI18nizableTextValue((Configuration)childLabel, (String)("plugin." + this._pluginName), (String)childLabel.getValue());
        Configuration childDesc = configuration.getChild("description");
        this._description = I18nizableText.getI18nizableTextValue((Configuration)childDesc, (String)("plugin." + this._pluginName), (String)childDesc.getValue());
        Configuration childConfig = configuration.getChild("category");
        this._category = I18nizableText.parseI18nizableText((Configuration)childConfig, (String)("plugin." + this._pluginName), (String)"");
        this._priority = Integer.parseInt(configuration.getChild("order").getValue());
        this._iconGlyph = configuration.getChild("icon-glyph").getValue();
        Configuration scriptsConf = configuration.getChild("scripts");
        this._scripts = ConfigurationHelper.parsePluginResourceList((Configuration)scriptsConf, (String)this._pluginName, (Logger)this.getLogger());
        this._xslt = configuration.getChild("xslt").getValue();
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public Integer getDisplayOrder() {
        return this._priority;
    }

    @Override
    public String getIconGlyph() {
        return this._iconGlyph;
    }

    @Override
    public List<ClientSideElement.ScriptFile> getScripts() {
        return this._scripts;
    }

    @Override
    public String getDisplayXSLT() {
        return this._xslt;
    }

    @Override
    public I18nizableText getCategory() {
        return this._category;
    }

    @Override
    public Model getModel() {
        if (this._formQuestionModel == null) {
            try {
                List<ModelItem> items = this._getModelItems();
                ModelItem[] modelItems = items.toArray(new ModelItem[items.size()]);
                this._formQuestionModel = Model.of((String)(this.getId() + ".model.id"), (String)(this.getId() + ".family.id"), (ModelItem[])modelItems);
            }
            catch (Exception e) {
                this.getLogger().error("An error occurred getting the form question model", (Throwable)e);
                throw new RuntimeException("An error occurred getting the form question model", e);
            }
        }
        return this._formQuestionModel;
    }

    @Override
    public Model getEntryModel(FormQuestion question) {
        try {
            ModelItem item = this._getEntryModelItem(question);
            String name = question.getNameForForm();
            return Model.of((String)(this.getId() + "." + name + ".model.entry.id"), (String)(this.getId() + "." + name + ".family.entry.id"), (ModelItem[])new ModelItem[]{item});
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred getting the form entry model", (Throwable)e);
            throw new RuntimeException("An error occurred getting the form entry model", e);
        }
    }

    protected List<ModelItem> _getModelItems() {
        ArrayList<ModelItem> modelItems = new ArrayList<ModelItem>();
        ElementDefinition title = FormElementDefinitionHelper.getElementDefinition("title", "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_QUESTION", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_QUESTION_DESC", (Validator)new DefaultValidator(null, true));
        title.setDefaultValue((Object)this._i18nUtils.translate((I18nizable)this.getDefaultTitle()));
        modelItems.add((ModelItem)title);
        ElementDefinition type = FormElementDefinitionHelper.getElementDefinition("type", "string", null, null, (Validator)new DefaultValidator(null, true));
        modelItems.add((ModelItem)type);
        ElementDefinition nameForForm = FormElementDefinitionHelper.getElementDefinition("name-for-form", "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_NAME_FOR_FORMS", "PLUGINS_FORMS_QUESTIONS_DIALOG_NAME_FOR_FORMS_DESC", (Validator)new NameForFormValidator("^[a-zA-Z0-9_-]*$", true));
        modelItems.add((ModelItem)nameForForm);
        ElementDefinition rule = FormElementDefinitionHelper.getElementDefinition("rule", "rule", "PLUGINS_FORMS_QUESTIONS_DIALOG_RULE_TITLE", "PLUGINS_FORMS_QUESTIONS_DIALOG_RULE_TITLE_DESC", null);
        rule.setWidget("edition.question-rules");
        RepeaterDefinition rulesRepeater = FormElementDefinitionHelper.getRepeaterDefinition("rules", new ElementDefinition[]{rule}, "PLUGINS_FORMS_QUESTIONS_DIALOG_RULES_TITLE", "PLUGINS_FORMS_QUESTIONS_DIALOG_RULES_TITLE_DESC", "PLUGINS_FORMS_QUESTIONS_DIALOG_RULES_ADD_LABEL", "PLUGINS_FORMS_QUESTIONS_DIALOG_RULES_DELETE_LABEL", 1);
        modelItems.add((ModelItem)rulesRepeater);
        return modelItems;
    }

    @Override
    public View getView(Form form) {
        View view = new View();
        view.setLabel(this.getLabel());
        view.setDescription(this.getDescription());
        view.setIconGlyph(this.getIconGlyph());
        for (ViewItem viewItem : this._getTabs(form)) {
            view.addViewItem(viewItem);
        }
        return view;
    }

    protected abstract List<ViewItemGroup> _getTabs(Form var1);

    protected SimpleViewItemGroup _createMainTab() {
        SimpleViewItemGroup fieldset = new SimpleViewItemGroup();
        fieldset.setName("general");
        fieldset.setLabel(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_MAIN"));
        fieldset.setRole("tab");
        return fieldset;
    }

    protected SimpleViewItemGroup _createAdvancedTab() {
        SimpleViewItemGroup advancedFieldset = new SimpleViewItemGroup();
        advancedFieldset.setName("advanced");
        advancedFieldset.setLabel(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_ADVANCED"));
        advancedFieldset.setRole("tab");
        return advancedFieldset;
    }

    protected SimpleViewItemGroup _getRulesTab() {
        SimpleViewItemGroup ruleFieldset = new SimpleViewItemGroup();
        ruleFieldset.setName("rules");
        ruleFieldset.setLabel(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RULE_FIELDSET"));
        ruleFieldset.setDescription(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RULE_FIELDSET_DESC"));
        ruleFieldset.setRole("tab");
        ModelItemGroup rulesModelItem = (ModelItemGroup)this.getModel().getModelItem("rules");
        ModelViewItemGroup rules = ModelViewItemGroup.of((ModelItemGroup)rulesModelItem);
        ruleFieldset.addViewItem((ViewItem)rules);
        return ruleFieldset;
    }

    protected ModelItem _getEntryModelItem(FormQuestion question) {
        try {
            String storageType = this.getStorageType(question);
            DefaultElementDefinition item = DefaultElementDefinition.of((String)question.getNameForForm(), (boolean)false, (String)storageType, (String)FormQuestionDataTypeExtensionPoint.ROLE);
            item.setLabel(new I18nizableText(question.getTitle()));
            return item;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't have entry model item for question id '" + question.getId() + "'", e);
        }
    }

    @Override
    public boolean isQuestionConfigured(FormQuestion question) {
        return true;
    }

    @Override
    public void saxAdditionalInfos(ContentHandler contentHandler, FormQuestion question) throws SAXException {
    }

    @Override
    public void doAdditionalOperations(FormQuestion question, Map<String, Object> values) {
    }

    @Override
    public void validateQuestionValues(Map<String, Object> values, Map<String, I18nizableText> errors) {
        String nameForForm = (String)values.get("name-for-form");
        if (StringUtils.startsWith((CharSequence)nameForForm, (CharSequence)"ametys-")) {
            errors.put("name-for-form", new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORMS_RENDER_ERROR_NAME_FOR_FORM"));
        }
    }

    @Override
    public void validateEntryValues(FormQuestion question, Map<String, Object> values, Multimap<String, I18nizableText> errors, Optional<Long> currentStepId, Map<String, Object> additionalParameters) {
        String nameForForm;
        Object value;
        boolean ignoreWriteRestriction = (Boolean)additionalParameters.getOrDefault("ignoreWriteRestriction", false);
        if (!ignoreWriteRestriction && currentStepId.isPresent() && !question.canWrite(currentStepId.get()) && (value = values.get(nameForForm = question.getNameForForm())) != null) {
            errors.put((Object)nameForForm, (Object)new I18nizableText("plugin.forms", "PLUGINS_FORMS_VALIDATOR_RESTICTED_IN_WRITING"));
        }
    }

    @Override
    public void saxEntryValue(ContentHandler contentHandler, FormQuestion question, FormEntry entry) throws SAXException {
        String dataName = question.getNameForForm();
        ModelItem definition = entry.getDefinition(dataName);
        DataContext context = RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)entry).withDataPath(dataName);
        if (entry.hasValue(dataName)) {
            definition.getType().valueToSAX(contentHandler, "value", entry.getValue(dataName), context);
        }
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished(FormQuestion question) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("name-for-form");
        fieldNames.add("type");
        fieldNames.add("rules");
        return fieldNames;
    }
}

