/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.types;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.question.types.AbstractFormQuestionType;
import org.ametys.plugins.forms.question.validators.DateTimeIntervalFormValidator;
import org.ametys.plugins.forms.question.validators.LocalDateIntervalFormValidator;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Validator;
import org.apache.commons.lang3.StringUtils;

public class DateTimeQuestionType
extends AbstractFormQuestionType {
    public static final String ATTRIBUTE_MIN_DATE = "min-date";
    public static final String ATTRIBUTE_MAX_DATE = "max-date";
    public static final String ATTRIBUTE_MIN_DATETIME = "min-datetime";
    public static final String ATTRIBUTE_MAX_DATETIME = "max-datetime";
    public static final String ATTRIBUTE_DATE_FORMAT = "date-format";
    public static final String DATE_TIME_FORMAT_VALUE = "datetime";
    public static final String DATE_FORMAT_VALUE = "date";
    public static final String DEFAULT_TITLE = "PLUGIN_FORMS_QUESTION_DEFAULT_TITLE_DATE";

    @Override
    protected List<ModelItem> _getModelItems() {
        List<ModelItem> modelItems = super._getModelItems();
        DisableConditions datetimeDisableConditions = new DisableConditions();
        DisableCondition conditionDatetime = new DisableCondition(ATTRIBUTE_DATE_FORMAT, DisableCondition.OPERATOR.NEQ, DATE_TIME_FORMAT_VALUE);
        datetimeDisableConditions.getConditions().add(conditionDatetime);
        ElementDefinition minDateTime = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_MIN_DATETIME, DATE_TIME_FORMAT_VALUE, "PLUGINS_FORMS_QUESTIONS_DIALOG_DATETIME_MIN_DATE", "PLUGINS_FORMS_QUESTIONS_DIALOG_DATETIME_MIN_DATE_DESC", null);
        minDateTime.setDisableConditions(datetimeDisableConditions);
        modelItems.add((ModelItem)minDateTime);
        ElementDefinition maxDateTime = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_MAX_DATETIME, DATE_TIME_FORMAT_VALUE, "PLUGINS_FORMS_QUESTIONS_DIALOG_DATETIME_MAX_DATE", "PLUGINS_FORMS_QUESTIONS_DIALOG_DATETIME_MAX_DATE_DESC", null);
        maxDateTime.setDisableConditions(datetimeDisableConditions);
        modelItems.add((ModelItem)maxDateTime);
        DisableConditions dateDisableConditions = new DisableConditions();
        DisableCondition conditionDate = new DisableCondition(ATTRIBUTE_DATE_FORMAT, DisableCondition.OPERATOR.NEQ, DATE_FORMAT_VALUE);
        dateDisableConditions.getConditions().add(conditionDate);
        ElementDefinition minDate = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_MIN_DATE, DATE_FORMAT_VALUE, "PLUGINS_FORMS_QUESTIONS_DIALOG_DATETIME_MIN_DATE", "PLUGINS_FORMS_QUESTIONS_DIALOG_DATETIME_MIN_DATE_DESC", null);
        minDate.setDisableConditions(dateDisableConditions);
        modelItems.add((ModelItem)minDate);
        ElementDefinition maxDate = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_MAX_DATE, DATE_FORMAT_VALUE, "PLUGINS_FORMS_QUESTIONS_DIALOG_DATETIME_MAX_DATE", "PLUGINS_FORMS_QUESTIONS_DIALOG_DATETIME_MAX_DATE_DESC", null);
        maxDate.setDisableConditions(dateDisableConditions);
        modelItems.add((ModelItem)maxDate);
        ElementDefinition format = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_DATE_FORMAT, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_DATETIME_FORMAT", "PLUGINS_FORMS_QUESTIONS_DIALOG_DATETIME_FORMAT_DESC", (Validator)new DefaultValidator(null, true));
        StaticEnumerator datetimeStaticEnumerator = new StaticEnumerator();
        datetimeStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_DATETIME_FORMAT_DATETIME"), (Object)DATE_TIME_FORMAT_VALUE);
        datetimeStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_DATETIME_FORMAT_DATE"), (Object)DATE_FORMAT_VALUE);
        format.setEnumerator((Enumerator)datetimeStaticEnumerator);
        format.setDefaultValue((Object)DATE_FORMAT_VALUE);
        modelItems.add((ModelItem)format);
        return modelItems;
    }

    @Override
    protected SimpleViewItemGroup _getMainTab() {
        SimpleViewItemGroup mainFieldset = super._getMainTab();
        ViewElement format = new ViewElement();
        format.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_DATE_FORMAT));
        mainFieldset.addViewItem((ViewItem)format);
        return mainFieldset;
    }

    @Override
    protected SimpleViewItemGroup _getAdvancedTab() {
        SimpleViewItemGroup advancedFieldset = super._getAdvancedTab();
        ViewElement minDate = new ViewElement();
        minDate.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_MIN_DATE));
        advancedFieldset.addViewItem((ViewItem)minDate);
        ViewElement maxDate = new ViewElement();
        maxDate.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_MAX_DATE));
        advancedFieldset.addViewItem((ViewItem)maxDate);
        ViewElement minDateTime = new ViewElement();
        minDateTime.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_MIN_DATETIME));
        advancedFieldset.addViewItem((ViewItem)minDateTime);
        ViewElement maxDateTime = new ViewElement();
        maxDateTime.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_MAX_DATETIME));
        advancedFieldset.addViewItem((ViewItem)maxDateTime);
        return advancedFieldset;
    }

    @Override
    public String getStorageType(FormQuestion question) {
        String type = (String)question.getValue(ATTRIBUTE_DATE_FORMAT);
        return DATE_TIME_FORMAT_VALUE.equals(type) ? DATE_TIME_FORMAT_VALUE : DATE_FORMAT_VALUE;
    }

    @Override
    protected ModelItem _getEntryModelItem(FormQuestion question) {
        ModelItem item = super._getEntryModelItem(question);
        if (DATE_TIME_FORMAT_VALUE.equals(question.getValue(ATTRIBUTE_DATE_FORMAT))) {
            ZonedDateTime minDate = (ZonedDateTime)question.getValue(ATTRIBUTE_MIN_DATETIME);
            ZonedDateTime maxDate = (ZonedDateTime)question.getValue(ATTRIBUTE_MAX_DATETIME);
            ((ElementDefinition)item).setValidator((Validator)new DateTimeIntervalFormValidator(null, this.isMandatory(question), minDate, maxDate));
        } else {
            LocalDate minDate = (LocalDate)question.getValue(ATTRIBUTE_MIN_DATE);
            LocalDate maxDate = (LocalDate)question.getValue(ATTRIBUTE_MAX_DATE);
            ((ElementDefinition)item).setValidator((Validator)new LocalDateIntervalFormValidator(null, this.isMandatory(question), minDate, maxDate));
        }
        return item;
    }

    @Override
    public void validateQuestionValues(Map<String, Object> values, Map<String, I18nizableText> errors) {
        String format;
        super.validateQuestionValues(values, errors);
        switch (format = (String)values.get(ATTRIBUTE_DATE_FORMAT)) {
            case "date": {
                String minDateAsString = values.getOrDefault(ATTRIBUTE_MIN_DATE, null);
                String maxDateAsString = values.getOrDefault(ATTRIBUTE_MAX_DATE, null);
                if (!StringUtils.isNotBlank((CharSequence)minDateAsString) || !StringUtils.isNotBlank((CharSequence)maxDateAsString)) break;
                LocalDate minDate = LocalDate.parse(minDateAsString);
                LocalDate maxDate = LocalDate.parse(maxDateAsString);
                if (minDate == null || maxDate == null || !minDate.isAfter(maxDate)) break;
                errors.put(ATTRIBUTE_MIN_DATE, new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_DATE_GAP_ERROR"));
                errors.put(ATTRIBUTE_MAX_DATE, new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_DATE_GAP_ERROR"));
                break;
            }
            case "datetime": {
                ZonedDateTime maxDateTime;
                ZonedDateTime minDateTime;
                String minDateTimeAsString = values.getOrDefault(ATTRIBUTE_MIN_DATETIME, null);
                String maxDateTimeAsString = values.getOrDefault(ATTRIBUTE_MAX_DATETIME, null);
                if (!StringUtils.isNotBlank((CharSequence)minDateTimeAsString) || !StringUtils.isNotBlank((CharSequence)maxDateTimeAsString) || !(minDateTime = DateUtils.parseZonedDateTime((String)minDateTimeAsString)).isAfter(maxDateTime = DateUtils.parseZonedDateTime((String)maxDateTimeAsString))) break;
                errors.put(ATTRIBUTE_MIN_DATETIME, new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_DATE_GAP_ERROR"));
                errors.put(ATTRIBUTE_MAX_DATETIME, new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_DATE_GAP_ERROR"));
                break;
            }
            default: {
                this.getLogger().error("Date format " + format + " is not supported");
            }
        }
    }

    @Override
    public I18nizableText getDefaultTitle() {
        return new I18nizableText("plugin.forms", DEFAULT_TITLE);
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished(FormQuestion question) {
        List<String> fieldNames = super.getFieldToDisableIfFormPublished(question);
        fieldNames.add(ATTRIBUTE_DATE_FORMAT);
        return fieldNames;
    }
}

