/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.types;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.question.types.AbstractFormQuestionType;
import org.ametys.plugins.forms.question.validators.FileFormValidator;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Validator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FileQuestionType
extends AbstractFormQuestionType {
    public static final String ATTRIBUTE_MAX_SIZE = "max-size";
    public static final String ATTRIBUTE_EXTENSIONS = "extensions";
    public static final String ATTRIBUTE_EXTENSIONS_OTHER = "extensions-other";
    public static final String DEFAULT_TITLE = "PLUGIN_FORMS_QUESTION_DEFAULT_TITLE_FILE";
    public static final String ALL_EXTENSIONS_VALUE = "_ametys_all_extension";
    public static final String IMAGE_EXTENSIONS_VALUE = "_ametys_image_extension";
    public static final String VIDEO_EXTENSIONS_VALUE = "_ametys_video_extension";
    public static final String AUDIO_EXTENSIONS_VALUE = "_ametys_audio_extension";
    public static final String DOCUMENT_EXTENSIONS_VALUE = "_ametys_document_extension";
    public static final String OTHER_EXTENSIONS_VALUE = "_ametys_other_extension";

    @Override
    protected List<ModelItem> _getModelItems() {
        List<ModelItem> modelItems = super._getModelItems();
        ElementDefinition maxSize = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_MAX_SIZE, "long", "PLUGINS_FORMS_QUESTIONS_DIALOG_FILE_MAX_SIZE", "PLUGINS_FORMS_QUESTIONS_DIALOG_FILE_MAX_SIZE_DESC", null);
        long maxSizeValue = this._getMaxSizeValue();
        maxSize.setWidget("edition.longfield");
        HashMap<String, I18nizableText> widgetParameters = new HashMap<String, I18nizableText>();
        widgetParameters.put("maxValue", new I18nizableText(String.valueOf(maxSizeValue)));
        widgetParameters.put("minValue", new I18nizableText("1"));
        widgetParameters.put("emptyText", new I18nizableText(String.valueOf(maxSizeValue)));
        maxSize.setWidgetParameters(widgetParameters);
        modelItems.add((ModelItem)maxSize);
        ElementDefinition extensions = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_EXTENSIONS, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_FILE_EXTENSIONS", "PLUGINS_FORMS_QUESTIONS_DIALOG_FILE_EXTENSIONS_DESC", null);
        StaticEnumerator extensionEnum = new StaticEnumerator();
        extensionEnum.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_FILE_EXTENSIONS_ALL"), (Object)ALL_EXTENSIONS_VALUE);
        extensionEnum.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_FILE_EXTENSIONS_DOCUMENTS"), (Object)DOCUMENT_EXTENSIONS_VALUE);
        extensionEnum.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_FILE_EXTENSIONS_IMAGES"), (Object)IMAGE_EXTENSIONS_VALUE);
        extensionEnum.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_FILE_EXTENSIONS_VIDEO"), (Object)VIDEO_EXTENSIONS_VALUE);
        extensionEnum.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_FILE_EXTENSIONS_AUDIO"), (Object)AUDIO_EXTENSIONS_VALUE);
        extensionEnum.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_FILE_EXTENSIONS_OTHER"), (Object)OTHER_EXTENSIONS_VALUE);
        extensions.setEnumerator((Enumerator)extensionEnum);
        extensions.setDefaultValue((Object)ALL_EXTENSIONS_VALUE);
        HashMap<String, I18nizableText> extWidgetParameters = new HashMap<String, I18nizableText>();
        extWidgetParameters.put("naturalOrder", new I18nizableText("true"));
        extensions.setWidgetParameters(extWidgetParameters);
        modelItems.add((ModelItem)extensions);
        ElementDefinition otherExtensions = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_EXTENSIONS_OTHER, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_FILE_OTHER_EXTENSIONS", "PLUGINS_FORMS_QUESTIONS_DIALOG_FILE_OTHER_EXTENSIONS_DESC", (Validator)new DefaultValidator("^\\.[a-z0-9]+(,\\s*\\.[a-z0-9]+)*$", false));
        DisableConditions disableConditions = new DisableConditions();
        DisableCondition condition = new DisableCondition(ATTRIBUTE_EXTENSIONS, DisableCondition.OPERATOR.NEQ, OTHER_EXTENSIONS_VALUE);
        disableConditions.getConditions().add(condition);
        otherExtensions.setDisableConditions(disableConditions);
        HashMap<String, I18nizableText> otherExtWidgetParameters = new HashMap<String, I18nizableText>();
        otherExtWidgetParameters.put("ametysShowMultipleHint", new I18nizableText("true"));
        otherExtensions.setWidgetParameters(otherExtWidgetParameters);
        modelItems.add((ModelItem)otherExtensions);
        return modelItems;
    }

    @Override
    protected SimpleViewItemGroup _getMainTab() {
        SimpleViewItemGroup mainFieldset = super._getMainTab();
        ViewElement extensions = new ViewElement();
        extensions.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_EXTENSIONS));
        mainFieldset.addViewItem((ViewItem)extensions);
        ViewElement otherExtensions = new ViewElement();
        otherExtensions.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_EXTENSIONS_OTHER));
        mainFieldset.addViewItem((ViewItem)otherExtensions);
        return mainFieldset;
    }

    @Override
    protected SimpleViewItemGroup _getAdvancedTab() {
        SimpleViewItemGroup advancedFieldset = super._getAdvancedTab();
        ViewElement maxSize = new ViewElement();
        maxSize.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_MAX_SIZE));
        advancedFieldset.addViewItem((ViewItem)maxSize);
        return advancedFieldset;
    }

    @Override
    public void validateQuestionValues(Map<String, Object> values, Map<String, I18nizableText> errors) {
        super.validateQuestionValues(values, errors);
        Number sizeAsNumber = values.getOrDefault(ATTRIBUTE_MAX_SIZE, null);
        Long maxSize = this._getMaxSizeValue();
        Long size = sizeAsNumber != null ? sizeAsNumber.longValue() : maxSize.longValue();
        if (size > maxSize) {
            List<String> errorParams = Arrays.asList(String.valueOf(maxSize));
            errors.put(ATTRIBUTE_MAX_SIZE, new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_FILE_MAXSIZE_ERROR", errorParams));
        }
    }

    private long _getMaxSizeValue() {
        long maxSizeValue = 0xA00000L;
        Long maxUploadSizeParam = (Long)Config.getInstance().getValue("runtime.upload.max-size");
        if (maxUploadSizeParam != null) {
            maxSizeValue = maxUploadSizeParam.intValue();
        }
        return maxSizeValue / 0x100000L;
    }

    @Override
    public String getStorageType(FormQuestion question) {
        return "file";
    }

    @Override
    protected ModelItem _getEntryModelItem(FormQuestion question) {
        ModelItem item = super._getEntryModelItem(question);
        ((ElementDefinition)item).setValidator((Validator)new FileFormValidator(null, this.isMandatory(question), (Long)question.getValue(ATTRIBUTE_MAX_SIZE, false, this._getMaxSizeValue()), this._getAllowedExtensions(question)));
        return item;
    }

    @Override
    public void saxAdditionalInfos(ContentHandler contentHandler, FormQuestion question) throws SAXException {
        super.saxAdditionalInfos(contentHandler, question);
        XMLUtils.createElement((ContentHandler)contentHandler, (String)"allowed-extensions", (String)this._getAllowedExtensions(question));
        Long maxSize = (Long)question.getValue(ATTRIBUTE_MAX_SIZE, false, this._getMaxSizeValue());
        XMLUtils.createElement((ContentHandler)contentHandler, (String)ATTRIBUTE_MAX_SIZE, (String)String.valueOf(maxSize));
    }

    private String _getAllowedExtensions(FormQuestion question) {
        String value;
        switch (value = (String)question.getValue(ATTRIBUTE_EXTENSIONS, false, ALL_EXTENSIONS_VALUE)) {
            case "_ametys_document_extension": {
                return ".txt, .pdf, .xls, .xlsx, .doc, .docx, .ptt, .pttx, .odt, .ods, .odp, .odb, .odg, .odf";
            }
            case "_ametys_image_extension": {
                return ".png, .gif, .jpg, .jpeg";
            }
            case "_ametys_video_extension": {
                return ".mp4, .m4v, .mov, .avi, .flv, .wmv, .mpeg, .mkv";
            }
            case "_ametys_audio_extension": {
                return ".wav, .wave, .flac, .m4a, .wma, .wmv, .mp3, .ogg, .oga, .mogg, .aac, .aiff, .aif";
            }
            case "_ametys_other_extension": {
                return (String)question.getValue(ATTRIBUTE_EXTENSIONS_OTHER, false, "");
            }
        }
        return "";
    }

    @Override
    public I18nizableText getDefaultTitle() {
        return new I18nizableText("plugin.forms", DEFAULT_TITLE);
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished(FormQuestion question) {
        List<String> fieldNames = super.getFieldToDisableIfFormPublished(question);
        fieldNames.add(ATTRIBUTE_EXTENSIONS);
        fieldNames.add(ATTRIBUTE_EXTENSIONS_OTHER);
        return fieldNames;
    }
}

