/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.types;

import java.util.HashMap;
import java.util.List;
import org.ametys.cms.data.File;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;

public interface IllustrableFormQuestionType {
    public static final String ATTRIBUTE_PICTURE = "picture";
    public static final String ATTRIBUTE_PICTURE_ALTERNATIVE = "picture-alternative";

    default public List<ModelItem> getIllustrationModelItems() {
        ElementDefinition illustration = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_PICTURE, "file", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_IMAGE", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_IMAGE_DESC", null);
        illustration.setWidget("edition.file");
        HashMap<String, I18nizableText> widgetParams = new HashMap<String, I18nizableText>();
        widgetParams.put("allowSources", new I18nizableText("external"));
        widgetParams.put("filter", new I18nizableText("image"));
        illustration.setWidgetParameters(widgetParams);
        ElementDefinition illustrationAlternative = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_PICTURE_ALTERNATIVE, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_IMAGE_ALT", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_IMAGE_ALT_DESC", null);
        return List.of(illustration, illustrationAlternative);
    }

    default public SimpleViewItemGroup getIllustrationTab(Model model) {
        SimpleViewItemGroup pictureFieldset = new SimpleViewItemGroup();
        pictureFieldset.setName("illustration");
        pictureFieldset.setLabel(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_IMAGE_FIELDSET"));
        pictureFieldset.setRole("tab");
        ViewElement picture = new ViewElement();
        picture.setDefinition((ElementDefinition)model.getModelItem(ATTRIBUTE_PICTURE));
        pictureFieldset.addViewItem((ViewItem)picture);
        ViewElement pictureAlternative = new ViewElement();
        pictureAlternative.setDefinition((ElementDefinition)model.getModelItem(ATTRIBUTE_PICTURE_ALTERNATIVE));
        pictureFieldset.addViewItem((ViewItem)pictureAlternative);
        return pictureFieldset;
    }

    default public File getIllustration(FormQuestion question) {
        return (File)question.getValue(ATTRIBUTE_PICTURE);
    }

    default public String getIllustrationAlternative(FormQuestion question) {
        return (String)question.getValue(ATTRIBUTE_PICTURE_ALTERNATIVE);
    }
}

