/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.repository;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.jcr.Node;
import org.ametys.cms.data.ametysobject.ModifiableModelAwareDataAwareAmetysObject;
import org.ametys.cms.data.holder.ModifiableIndexableDataHolder;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeater;
import org.ametys.cms.data.holder.impl.DefaultModifiableModelAwareDataHolder;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.types.MandatoryAwareFormQuestionType;
import org.ametys.plugins.forms.question.types.RestrictiveQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormPage;
import org.ametys.plugins.forms.repository.FormPageRule;
import org.ametys.plugins.forms.repository.FormQuestionFactory;
import org.ametys.plugins.forms.repository.type.Rule;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.NotUniqueTypeException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.ametys.runtime.model.exception.UnknownTypeException;
import org.ametys.web.repository.SiteAwareAmetysObject;
import org.ametys.web.repository.site.Site;

public class FormQuestion
extends DefaultTraversableAmetysObject<FormQuestionFactory>
implements ModifiableModelAwareDataAwareAmetysObject,
SiteAwareAmetysObject {
    public static final String ATTRIBUTE_PAGE_ID = "pageId";
    public static final String ATTRIBUTE_TITLE = "title";
    public static final String ATTRIBUTE_NAME_FOR_FORM = "name-for-form";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_RULES = "rules";
    public static final String ATTRIBUTE_RULE = "rule";

    public FormQuestion(Node node, String parentPath, FormQuestionFactory factory) {
        super(node, parentPath, (DefaultTraversableAmetysObjectFactory)factory);
    }

    public FormPage getFormPage() throws AmetysRepositoryException {
        return (FormPage)this.getParent();
    }

    public Form getForm() throws AmetysRepositoryException {
        return this.getFormPage().getForm();
    }

    public FormQuestionType getType() {
        String typeId = (String)this.getValue(ATTRIBUTE_TYPE);
        return (FormQuestionType)((FormQuestionFactory)this._getFactory()).getFormQuestionTypeExtensionPoint().getExtension(typeId);
    }

    public void setTypeId(String typeId) {
        this.setValue(ATTRIBUTE_TYPE, typeId);
    }

    public void setTypeId(FormQuestionType type) {
        this.setValue(ATTRIBUTE_TYPE, type.getId());
    }

    public String getNameForForm() {
        return (String)this.getValue(ATTRIBUTE_NAME_FOR_FORM);
    }

    public void setNameForForm(String name) {
        this.setValue(ATTRIBUTE_NAME_FOR_FORM, name);
    }

    public String getTitle() {
        return (String)this.getValue(ATTRIBUTE_TITLE);
    }

    public void setTitle(String title) {
        this.setValue(ATTRIBUTE_TITLE, title);
    }

    public boolean isMandatory() {
        return this.getType() instanceof MandatoryAwareFormQuestionType ? ((MandatoryAwareFormQuestionType)((Object)this.getType())).isMandatory(this) : false;
    }

    public boolean isReadRestricted() {
        return this.getType() instanceof RestrictiveQuestionType ? ((RestrictiveQuestionType)((Object)this.getType())).isReadRestricted(this) : false;
    }

    public boolean canRead(Long currentStep) {
        FormQuestionType formQuestionType = this.getType();
        if (formQuestionType instanceof RestrictiveQuestionType) {
            RestrictiveQuestionType type = (RestrictiveQuestionType)((Object)formQuestionType);
            return !this.isReadRestricted() || type.getReadingSteps(this).contains(currentStep);
        }
        return true;
    }

    public boolean isModifiable() {
        return this.getType() instanceof RestrictiveQuestionType ? ((RestrictiveQuestionType)((Object)this.getType())).isModifiable(this) : false;
    }

    public boolean canWrite(Long currentStep) {
        if (currentStep.equals(RestrictiveQuestionType.INITIAL_WORKFLOW_ID)) {
            return true;
        }
        FormQuestionType formQuestionType = this.getType();
        if (formQuestionType instanceof RestrictiveQuestionType) {
            RestrictiveQuestionType type = (RestrictiveQuestionType)((Object)formQuestionType);
            return this.isModifiable() && type.getWritingSteps(this).contains(currentStep);
        }
        return false;
    }

    public List<Rule> getQuestionRules() {
        List<Rule> rules = new ArrayList<Rule>();
        ModifiableIndexableRepeater value = this.getRepeater(ATTRIBUTE_RULES);
        if (value != null) {
            rules = value.getEntries().stream().map(e -> (Rule)e.getValue(ATTRIBUTE_RULE)).collect(Collectors.toList());
        }
        return rules;
    }

    public Optional<Rule> getFirstQuestionRule() {
        List<Rule> questionRules = this.getQuestionRules();
        return questionRules.isEmpty() ? Optional.empty() : Optional.of(questionRules.get(0));
    }

    public List<FormPageRule> getPageRules() throws AmetysRepositoryException {
        LinkedList<FormPageRule> rules = new LinkedList<FormPageRule>();
        if (this.hasChild("ametys-internal:form-page-rules")) {
            ModifiableTraversableAmetysObject ruleRoot = (ModifiableTraversableAmetysObject)this.getChild("ametys-internal:form-page-rules");
            rules.addAll(ruleRoot.getChildren().stream().map(rule -> (FormPageRule)((Object)rule)).collect(Collectors.toList()));
        }
        return rules;
    }

    public boolean hasPageRule(String option) throws AmetysRepositoryException {
        if (this.hasChild("ametys-internal:form-page-rules")) {
            return ((ModifiableTraversableAmetysObject)this.getChild("ametys-internal:form-page-rules")).hasChild(option);
        }
        return false;
    }

    public void addPageRules(String option, FormPageRule.PageRuleType ruleType, String pageId) {
        ModifiableTraversableAmetysObject rulesRoot = this.hasChild("ametys-internal:form-page-rules") ? (ModifiableTraversableAmetysObject)this.getChild("ametys-internal:form-page-rules") : (ModifiableTraversableAmetysObject)this.createChild("ametys-internal:form-page-rules", "ametys:collection");
        FormPageRule ruleNode = (FormPageRule)rulesRoot.createChild(option, "ametys:form-page-rule");
        ruleNode.setType(ruleType);
        ruleNode.setOption(option);
        if (ruleType == FormPageRule.PageRuleType.JUMP || ruleType == FormPageRule.PageRuleType.SKIP) {
            ruleNode.setPageId(pageId);
        }
    }

    public void deletePageRule(String option) throws AmetysRepositoryException {
        ModifiableTraversableAmetysObject rulesRoot = (ModifiableTraversableAmetysObject)this.getChild("ametys-internal:form-page-rules");
        if (rulesRoot.hasChild(option)) {
            ((FormPageRule)rulesRoot.getChild(option)).remove();
        }
    }

    public void copyTo(ModifiableDataHolder dataHolder) throws UndefinedItemPathException, BadItemTypeException, UnknownTypeException, NotUniqueTypeException {
        super.copyTo(dataHolder);
        dataHolder.removeValue(ATTRIBUTE_RULES);
    }

    public String getSiteName() throws AmetysRepositoryException {
        return this.getForm().getSiteName();
    }

    public Site getSite() throws AmetysRepositoryException {
        return this.getForm().getSite();
    }

    public ModifiableIndexableDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelAwareDataHolder((ModifiableRepositoryData)repositoryData, (ModelItemContainer)((FormQuestionFactory)this._getFactory()).getFormQuestionModel());
    }

    public boolean isCacheable() {
        return this.getType().isCacheable(this);
    }
}

