/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.repository.type;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.ametys.plugins.forms.repository.type.AbstractMatrixElementType;
import org.ametys.plugins.forms.repository.type.Matrix;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.type.RepositoryElementType;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.apache.commons.lang3.StringUtils;

public class MatrixRepositoryElementType
extends AbstractMatrixElementType
implements RepositoryElementType<Matrix> {
    public String getRepositoryDataType() {
        return "string";
    }

    public Object read(RepositoryData parentData, String name) throws BadItemTypeException {
        if (!parentData.hasValue(name)) {
            return null;
        }
        if (!this.isCompatible(parentData, name)) {
            throw new BadItemTypeException("Try to get " + this.getId() + " value from the non " + this.getId() + " data '" + name + "' on '" + parentData + "'");
        }
        if (parentData.isMultiple(name)) {
            String[] values = parentData.getStrings(name);
            return Arrays.stream(values).map(this::_string2Matrix).toArray(Matrix[]::new);
        }
        String value = parentData.getString(name);
        return this._string2Matrix(value);
    }

    public boolean hasNonEmptyValue(RepositoryData parentData, String name) throws BadItemTypeException {
        if (!parentData.hasValue(name)) {
            return false;
        }
        if (!this.isCompatible(parentData, name)) {
            throw new BadItemTypeException("Try to check matrix value from the non " + this.getId() + " data '" + name + "' on '" + parentData + "'");
        }
        if (parentData.isMultiple(name)) {
            return parentData.getStrings(name).length > 0;
        }
        return StringUtils.isNotEmpty((CharSequence)parentData.getString(name));
    }

    public void write(ModifiableRepositoryData parentData, String name, Object value) throws BadItemTypeException {
        if (value == null) {
            if (parentData.hasValue(name) && parentData.isMultiple(name)) {
                parentData.setValues(name, new String[0]);
            } else {
                parentData.setValue(name, "");
            }
        } else if (value instanceof String) {
            parentData.setValue(name, (String)value);
        } else if (value instanceof String[]) {
            Arrays.stream((String[])value).forEach(v -> Optional.ofNullable(v).orElseThrow(() -> new IllegalArgumentException("Try to set a null value into the multiple " + this.getId() + " data '" + name + "' on '" + parentData + "'")));
            parentData.setValues(name, (String[])value);
        } else if (value instanceof Matrix) {
            Matrix matrix = (Matrix)value;
            parentData.setValue(name, this._jsonUtils.convertObjectToJson((Object)matrix));
        } else if (value instanceof Matrix[]) {
            String[] values = (String[])Stream.of((Matrix[])value).map(m -> this._jsonUtils.convertObjectToJson(m)).toArray(String[]::new);
            parentData.setValues(name, values);
        } else if (value instanceof List) {
            List matrixList = (List)value;
            String[] matrixListAsJson = (String[])matrixList.stream().map(m -> this._jsonUtils.convertObjectToJson(m)).toArray(String[]::new);
            parentData.setValues(name, matrixListAsJson);
        } else {
            throw new BadItemTypeException("Try to set the non " + this.getId() + " value '" + value + "' to the " + this.getId() + " data '" + name + "' on '" + parentData + "'");
        }
    }
}

