/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.cms.workflow.AmetysObjectCheckRightsCondition;
import org.ametys.plugins.forms.helper.FormMailHelper;
import org.ametys.plugins.forms.helper.LimitedEntriesHelper;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.EnhancedFunction;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ActiveEntryFunction
extends AbstractWorkflowComponent
implements EnhancedFunction {
    protected LimitedEntriesHelper _limitedEntriesHelper;
    protected FormMailHelper _formMailHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._limitedEntriesHelper = (LimitedEntriesHelper)((Object)manager.lookup(LimitedEntriesHelper.ROLE));
        this._formMailHelper = (FormMailHelper)((Object)manager.lookup(FormMailHelper.ROLE));
    }

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        FormEntry entry = (FormEntry)((Object)transientVars.get(AmetysObjectCheckRightsCondition.AMETYS_OBJECT_KEY));
        if (!entry.isActive().booleanValue()) {
            if (this._limitedEntriesHelper.isFormLimitIsReached(entry.getForm())) {
                ArrayList<String> i18nParams = new ArrayList<String>();
                i18nParams.add(entry.getForm().getTitle());
                this.addWorkflowError(transientVars, new I18nizableText("plugin.forms", "PLUGINS_FORMS_ACTIVE_ENTRY_LIMIT_CONDITION_FAILED", i18nParams));
                throw new InvalidActionException("Can activate the entry because the form (" + entry.getForm().getId() + ") limit is reach");
            }
            entry.setActive(true);
            Form form = entry.getForm();
            Optional<String[]> emailsAsArrayOpt = form.getAdminEmails();
            if (emailsAsArrayOpt.isPresent()) {
                String[] emailsAsArray = emailsAsArrayOpt.get();
                if (form.isEntriesLimited()) {
                    int totalSubmissions = form.getActiveEntries().size();
                    Long maxEntries = form.getMaxEntries().get();
                    if (maxEntries == (long)totalSubmissions) {
                        this._formMailHelper.sendLimitationReachedMailForAdmin(entry, emailsAsArray, FormMailHelper.LimitationMailType.LIMIT);
                    } else if (form.isQueueEnabled() && form.getQueueSize().isPresent() && form.getQueueSize().get() + maxEntries == (long)totalSubmissions) {
                        this._formMailHelper.sendLimitationReachedMailForAdmin(entry, emailsAsArray, FormMailHelper.LimitationMailType.QUEUE);
                    }
                }
            }
        }
    }

    public EnhancedFunction.FunctionType getFunctionExecType() {
        return EnhancedFunction.FunctionType.PRE;
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_ACTIVE_ENTRY_FUNCTION_LABEL");
    }

    public List<WorkflowHelper.WorkflowVisibility> getVisibilities() {
        List visibilities = super.getVisibilities();
        visibilities.add(WorkflowHelper.WorkflowVisibility.USER);
        return visibilities;
    }
}

