<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    exclude-result-prefixes="ametys resolver">

    <xsl:variable name="date-time-format" select="ametys:translate('plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_DATE_TIME_FORMAT', $lang)"></xsl:variable>
    <xsl:variable name="cssPrefix">form-dashboard</xsl:variable>
    <xsl:variable name="get-entry-fields-url">/dashboard/form-entry/view.html</xsl:variable>
    <xsl:variable name="dashboard-view">default</xsl:variable>
    
    <xsl:template name="dashboard-css">
        <xsl:call-template name="select2-css" />
    </xsl:template>
    
    <xsl:template name="dashboard-js">
        <xsl:call-template name="select2-js"/>
        <xsl:call-template name="dashboard-helper-js" />
        <xsl:call-template name="dashboard-dialog-js" />
        <xsl:call-template name="dashboard-initialize-js"/>
    </xsl:template>
    
    <xsl:template name="select2-css">
        <link rel="stylesheet" href="{ametys:pluginResourceURL('forms', 'vendor/css/select2/select2.css')}"/>
    </xsl:template>
    
    <xsl:template name="select2-js">
        <script src="{ametys:pluginResourceURL('forms', 'vendor/js/select2/select2.js')}" type="text/javascript"/>
        <xsl:variable name="langUrl">vendor/js/select2/i18n/<xsl:value-of select="ametys:translate('plugin.forms:PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_SELECT2_IMPORT_LANG', ametys:lang())" />.js</xsl:variable>
        <script src="{ametys:pluginResourceURL('forms', $langUrl)}" type="text/javascript"/>
    </xsl:template>
    
    <xsl:template name="dashboard-helper-js">
        <script type="text/javascript"  src="{$uri-prefix}/plugins/forms/resources/js/DashboardHelper.{ametys:lang()}.js"/>
    </xsl:template>

    <xsl:template name="dashboard-dialog-js">
        <script type="text/javascript">
        function onShowEntry_<xsl:value-of select="$uniqueId" />(formId, entryId, formLabel)
        {
            $j("[data-dashboard-entry-dialog='<xsl:value-of select="$uniqueId" />']").dialog({
              modal: true,
              buttons: {
                "<i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_OK_BUTTON" i18n:catalogue="plugin.forms"/>": function() {
                  $j( this ).dialog( "close" );
                }
              },
              width: 500,
              maxHeight: window.innerHeight*0.8
            });
        }
        
        function onShowHistory_<xsl:value-of select="$uniqueId" />(formId, entryId)
        {
            $j("*[data-dashboard-history-dialog='<xsl:value-of select="$uniqueId" />-" + formId + "-" + entryId + "']").dialog({
              modal: true,
              buttons: {
                "<i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_OK_BUTTON" i18n:catalogue="plugin.forms"/>": function() {
                    $j( this ).dialog( "close" );
                }
              },
              width: 500,
              maxHeight: window.innerHeight*0.8
            });
        }
        
        function onShowError_<xsl:value-of select="$uniqueId"/>(title, errorMsg)
        {
            $j("[data-dashboard-error-dialog='<xsl:value-of select="$uniqueId" />']").find('[data-dashboard-error-dialog-message]').text(errorMsg);
            $j("[data-dashboard-error-dialog='<xsl:value-of select="$uniqueId" />']").dialog({
              title: title || "<i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ERROR_TITLE" i18n:catalogue="plugin.forms"/>",
              modal: true,
              buttons: {
                "<i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_OK_BUTTON" i18n:catalogue="plugin.forms"/>": function() {
                  $j( this ).dialog( "close" );
                }
              },
              width: 500,
              maxHeight: window.innerHeight*0.8
            });
        }
        
        function onShowDashboard_<xsl:value-of select="$uniqueId"/>()
        {
            // Nothing to do
        }
        
        function onHideActionDialog_<xsl:value-of select="$uniqueId" />()
        {
            var uniqueId = '<xsl:value-of select="$uniqueId" />';
            $dialog = $j(`.ui-dialog-content[data-dashboard-popup='${uniqueId}']`);
            $dialog.dialog( "destroy" );
        }
        
        function onShowActionDialog_<xsl:value-of select="$uniqueId" />(actionName, formId, entryId, actionId)
        {
            var buttons = {};
            if (actionName == "edit")
            {
                buttons = {
                    "<i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_VALIDATE_BUTTON" i18n:catalogue="plugin.forms"/>": function() {
                        DashboardHelper.editFormEntry("<xsl:value-of select="$uniqueId" />", formId, entryId, actionId);
                    },
                    "<i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_CANCEL_BUTTON" i18n:catalogue="plugin.forms"/>": function() {
                        $j( this ).dialog( "destroy" );
                    }
                }
            }
            else
            {
                buttons = {
                    "<i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_OK_BUTTON" i18n:catalogue="plugin.forms"/>": function() {
                        $j( this ).dialog( "destroy" );
                        DashboardHelper.doAction("<xsl:value-of select="$uniqueId" />", formId, entryId, actionId);
                    },
                    "<i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_CANCEL_BUTTON" i18n:catalogue="plugin.forms"/>": function() {
                        $j( this ).dialog( "destroy" );
                    }
                }
            }
        
            $j("*[data-dashboard-" + actionName + "-dialog= '" + formId + "-" + entryId + "-" + actionId + "']").dialog({
              modal: true,
              buttons: buttons,
              width: 500,
              maxHeight: window.innerHeight*0.8
            });
        }
        </script>
    </xsl:template>

    <xsl:template name="dashboard-initialize-js">
        <script type="text/javascript">
        $j().ready(function() {
            DashboardHelper.initialize("<xsl:value-of select="$uniqueId" />", {
                siteName: "<xsl:value-of select="$site"/>",
                lang: "<xsl:value-of select="$lang"/>",
                contextPath: "<xsl:value-of select="$site-uri-prefix"/>",
                entryUrl: "<xsl:value-of select="$get-entry-fields-url"/>",
                onShowDashboard: onShowDashboard_<xsl:value-of select="$uniqueId"/>,
                onShowEntry: onShowEntry_<xsl:value-of select="$uniqueId" />,
                onShowHistory: onShowHistory_<xsl:value-of select="$uniqueId" />,
                onShowError: onShowError_<xsl:value-of select="$uniqueId" />,
                onShowActionDialog: onShowActionDialog_<xsl:value-of select="$uniqueId" />,
                onHideActionDialog: onHideActionDialog_<xsl:value-of select="$uniqueId" />,
                dashboardView: "<xsl:value-of select="$dashboard-view"/>",
                zoneItemId: "<xsl:value-of select="ametys:zoneItemId()" />"
            });
        });
        </script>
    </xsl:template>
    
    <xsl:template name="dashboard">
         <xsl:call-template name="dashboard-table" />
     
         <xsl:apply-templates select="answer" mode="history"/>
         
         <!-- Edit by submitter action that need dialog -->
        <xsl:apply-templates select=".//action" mode="action-dialog"/>
         
         <xsl:call-template name="show-answer-popup" />
         
         <xsl:call-template name="show-error-popup" />
    </xsl:template>

    <xsl:template name="dashboard-table">
        <table class="{$cssPrefix}__table">
            <xsl:call-template name="dashboard-table-header" />
            <xsl:call-template name="dashboard-table-body" />
        </table>
    </xsl:template>
    
    <xsl:template name="dashboard-table-header">
        <thead>
           <tr>
               <th class="{$cssPrefix}__header__label" scope="col"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_LABEL_HEADER" i18n:catalogue="plugin.forms"/></th>
               <th class="{$cssPrefix}__header__creationdate" scope="col"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_CREATION_DATE_HEADER" i18n:catalogue="plugin.forms"/></th>
               <th class="{$cssPrefix}__header__updatedate" scope="col"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_MODIFICATION_DATE_HEADER" i18n:catalogue="plugin.forms"/></th>
               <th class="{$cssPrefix}__header__workflow" scope="col"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_WORKFLOW_HEADER" i18n:catalogue="plugin.forms"/></th>
               <th class="{$cssPrefix}__header__history" scope="col"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_HISTORY_HEADER" i18n:catalogue="plugin.forms"/></th>
           </tr>
       </thead>
    </xsl:template>
    
    <xsl:template name="dashboard-table-body">
        <tbody>
            <xsl:apply-templates select="answer" mode="row">
                <xsl:sort select="@creationDate" order="descending"/>
            </xsl:apply-templates>
        </tbody>
    </xsl:template>
    
    <xsl:template match="answer" mode="row">
        <tr>
            <xsl:apply-templates select="." mode="class-attribute"/>
            <xsl:apply-templates select="." mode="label"/>
            <xsl:apply-templates select="." mode="creation-date"/>
            <xsl:apply-templates select="." mode="update-date"/>
            <xsl:apply-templates select="." mode="workflow-step"/>
            <xsl:apply-templates select="." mode="open-history"/>
        </tr>
    </xsl:template>
    
    <xsl:template match="answer" mode="class-attribute">
        <xsl:if test="count(step) > 0">
           <xsl:attribute name="class"><xsl:value-of select="step[@isCurrent = 'true']/description/@status" /></xsl:attribute>
       </xsl:if>
    </xsl:template>
    
    <xsl:template match="answer" mode="label">
        <th scope="row" class="{$cssPrefix}__label" data-dashboard-actions="{@formId}-{@id}">
            <span class="label_mobile"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_LABEL_HEADER" i18n:catalogue="plugin.forms"/></span>
            <button type="button" 
                data-dashboard-open="{@formId}" 
                aria-haspopup="dialog"
                title="plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_SEE_FIELDS" i18n:attr="title">
                <xsl:choose>
                    <xsl:when test="action[@type = 'edit-by-submitter']">
                        <xsl:attribute name="onclick">DashboardHelper.doWorkflowAction("<xsl:value-of select="$uniqueId" />", "edit-by-submitter", "<xsl:value-of select="@formId" />", "<xsl:value-of select="@id" />", <xsl:value-of select="action[@type = 'edit-by-submitter']/@id" />, this)</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="onclick">DashboardHelper.showEntry("<xsl:value-of select="$uniqueId" />", "<xsl:value-of select="@formId" />", "<xsl:value-of select="@id" />", "<xsl:value-of select="ametys:escapeJS(@formLabel)"/>", this)</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
                <span><xsl:value-of select="@formLabel" /></span>
            </button>
        </th>
    </xsl:template>
    
    <xsl:template match="action[@type='edit-by-submitter']" mode="action-dialog">
        <div data-dashboard-popup="{$uniqueId}" data-dashboard-edit-dialog="{../@formId}-{../@id}-{@id}" style="display:none;" title="{.}">
           <div data-dashboard-edit-values="{../@formId}-{../@id}-{@id}">
                <!-- Rendered by edit.xsl -->
           </div>
           <xsl:apply-templates select="." mode="action-dialog-loader"/>
        </div>
    </xsl:template>
    
    <xsl:template match="action" mode="action-dialog"/>
    
    <xsl:template match="action" mode="action-dialog-loader">
        <div class="loading" data-ametys-dashboard-dialog-role="loading" style="display: none"></div>
    </xsl:template>
    
    <xsl:template match="answer" mode="creation-date">
        <td class="{$cssPrefix}__creationdate">
            <span class="label_mobile"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_CREATION_DATE_HEADER" i18n:catalogue="plugin.forms"/></span>
            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{@creationDate}"/>
        </td>
    </xsl:template>    
    
    <xsl:template match="answer" mode="update-date">
        <td class="{$cssPrefix}__updatedate">
            <span class="label_mobile"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_MODIFICATION_DATE_HEADER" i18n:catalogue="plugin.forms"/></span>
            <xsl:choose>
                <xsl:when test="count(step) > 0">
                    <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{step[@isCurrent = 'true']/@date}"/>
                </xsl:when>
                <xsl:otherwise>
                    <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{@creationDate}"/>
                </xsl:otherwise>
            </xsl:choose>
        </td>
    </xsl:template>    
    
    <xsl:template match="answer" mode="workflow-step">
        <td class="{$cssPrefix}__workflow">
            <span class="label_mobile"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_WORKFLOW_HEADER" i18n:catalogue="plugin.forms"/></span>
            <span>
                <xsl:choose>
                    <xsl:when test="count(step) > 0">
                        <xsl:value-of select="step[@isCurrent = 'true']/description/label" />
                    </xsl:when>
                    <xsl:otherwise>
                        <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_NO_WORKFLOW" i18n:catalogue="plugin.forms"/>
                    </xsl:otherwise>
                </xsl:choose>
            </span>
        </td>
    </xsl:template>
    
    <xsl:template match="answer" mode="open-history">
        <td class="{$cssPrefix}__history">
            <span class="label_mobile"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_LABEL_HEADER" i18n:catalogue="plugin.forms"/></span>
            <xsl:if test="count(step) > 0">
                <button type="button" onclick="DashboardHelper.showHistory('{$uniqueId}', '{@formId}', '{@id}', this)" title="plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_SEE_HISTORY" i18n:attr="title">
                    <span><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_HISTORY_HEADER" i18n:catalogue="plugin.forms"/></span>
                </button>
            </xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template name="show-answer-popup">
        <div data-dashboard-entry-dialog="{$uniqueId}" data-dashboard-entry-values-title="{$uniqueId}" data-dashboard-title-attr="title">
           <div data-dashboard-entry-values="{$uniqueId}">
                <!-- Rendered by entry-information.xsl -->
           </div>
        </div>
    </xsl:template>
        
    <xsl:template name="show-error-popup">
        <div data-dashboard-error-dialog="{$uniqueId}" style="display:none;">
           <div data-dashboard-error-dialog-message="true"/>
        </div>
    </xsl:template>
    
    <xsl:template match="answer" mode="history">
        <div data-dashboard-history-dialog="{$uniqueId}-{@formId}-{@id}" style="display:none;" title="plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_HISTORY" i18n:attr="title">
            <ul class="{$cssPrefix}__historysteps">
                <xsl:apply-templates select="step" mode="history"/>
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template match="step" mode="history">
        <xsl:variable name="currentCls"><xsl:if test="@isCurrent = 'true'"> current</xsl:if></xsl:variable>
        <li class="{$cssPrefix}__historystep {description/@status}{$currentCls}">
            <xsl:apply-templates select="." mode="icon"/>
            <xsl:apply-templates select="." mode="description"/>
            <xsl:apply-templates select="." mode="date"/>
            <xsl:apply-templates select="." mode="action"/>
        </li>
    </xsl:template>
    
    <xsl:template match="step" mode="date">
        <div class="{$cssPrefix}__historystep_date">
            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{@date}"/>
        </div>
    </xsl:template>
    
    <xsl:template match="step" mode="description">
        <div class="{$cssPrefix}__historystep_desc">
            <div><xsl:value-of select="description/label" /></div>
        </div>
    </xsl:template>
    
    <xsl:template match="step" mode="action">
        <div class="{$cssPrefix}__historystep_action">
            <xsl:value-of select="action/label" disable-output-escaping="yes"/>
            <xsl:apply-templates select="." mode="comment"/>
        </div>
    </xsl:template>
    
    <xsl:template match="step" mode="comment">
        <div class="{$cssPrefix}__historystep_comments">
            <i><xsl:value-of select="@comments" /></i>
        </div>
    </xsl:template>
    
    <xsl:template match="step" mode="icon">
        <div class="{$cssPrefix}__historystep_icon">
            <img src="{description/@icon}" />
        </div>
    </xsl:template>
    
</xsl:stylesheet>
