/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the data model for form entries.
 * @private
 */
Ext.define('Ametys.plugins.forms.tree.FormsTree.FormDirectoryEntry', {
    extend: 'Ext.data.Model',
    
    fields: [
        'id',
        'title',
        'isConfigured',
        {name: 'isForm', type: 'boolean'},
        {name: 'name', type: 'string',
            calculate: function (data) {
                return data.title;
            }
        },
        {name: 'hasChildren', type: 'boolean'},
        {name: 'hasNoDescendantForm', type: 'boolean'},
        {
            name: 'text', 
            type: 'string',
            calculate: function (data) {
                return data.title;
            }
        },
        {name: 'fullPath', type: 'string'},
        'author',
        {
            name: 'authorFullName', 
            type: 'string',
            calculate: function (data) {
                return data.author ? data.author.sortablename: '';
            }
        },
        'contributor',
        {
            name: 'contributorFullName', 
            type: 'string',
            calculate: function (data) {
                return data.contributor ? data.contributor.sortablename: '';
            }
        },
        {name: 'entriesAmount', mapping: 'entriesAmount'},
        {name: 'lastEntry', mapping: 'lastEntry'},
        {name: 'workflowName', mapping: 'workflowName'},
        
        {name: 'lastModificationDate', type:'date', dateFormat:'c'},
        {name: 'creationDate', type:'date', dateFormat:'c'},
        {name: 'description', type:'string'},
        {name: 'canRead', type: 'boolean', defaultValue: false},
        {name: 'canWrite', type: 'boolean', defaultValue: false},
        {name: 'canEditRight', type: 'boolean', defaultValue: false},
        {
            name: 'leaf', 
            type: 'boolean', 
            calculate: function(data) {
                return data.isForm;
            }
        },
        {
            name: 'expandable', 
            type: 'boolean', 
            calculate: function(data) {
                return data.root || (!data.isForm && data.hasChildren);
            }
        },
        {
            name: 'iconCls',
            calculate: function (data)
            {
                if (data.isForm)
                {
                    var iconCls = 'ametysicon-code-html-form';
                    if (!data.isConfigured)
                    {
                        iconCls += ' decorator-ametysicon-sign-caution' 
                    }
                    return iconCls;
                }
                else
                {
                    return 'ametysicon-folder249';
                }
            }
        }
    ],
    
    getFullPath: function()
    {
        var separator = " > ";
        var fullPath = this.getPath("text", separator);
        var i = fullPath.indexOf(separator, 1);
        return fullPath.substring(i + separator.length);
    }
});