/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.repository;

import javax.jcr.Node;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.forms.dao.FormDirectoryDAO;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;

/**
 * {@link AmetysObjectFactory} for handling {@link FormDirectory}s.
 */
public class FormDirectoryFactory extends DefaultTraversableAmetysObjectFactory
{
    /** JCR nodetype for form directory */
    public static final String FORM_DIRECTORY_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":forms";
    
    /** The Form DAO */
    protected FormDirectoryDAO _formDAO;
    
    @Override
    public FormDirectory getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new FormDirectory(node, parentPath, this);
    }
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _formDAO = (FormDirectoryDAO) manager.lookup(FormDirectoryDAO.ROLE);
    }
    
    FormDirectoryDAO getFormDirectoryDAO()
    {
        return _formDAO;
    }
}
