/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.ribbon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import org.ametys.core.ui.RibbonImport;

/**
 * Import manager for the dynamic generated ribbon.xml of the form plugin
 */
public class FormRibbonImportManager implements RibbonImport
{
    @Override
    public Map<List<String>, Pattern> getImports()
    {
        String workspaceMatch = "cms|web";
        Map<List<String>, Pattern> imports = new HashMap<>();
        List<String> importsList = new ArrayList<>();
        importsList.add("cocoon://plugins/forms/form-content-ribbon.xml");
        importsList.add("cocoon://plugins/forms/form-ribbon.xml");
        imports.put(importsList, Pattern.compile(workspaceMatch));
        
        return imports;
    }
}
