/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.plugins.forms.dao.FormDirectoryDAO;
import org.ametys.plugins.forms.repository.FormDirectory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryIntegrityViolationException;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;

public final class FormAndDirectoryCommonMethods {
    private FormAndDirectoryCommonMethods() {
    }

    public static boolean canMoveTo(String siteName, AmetysObject newParent, SimpleAmetysObject formOrFormDirectory, FormDirectoryDAO formDAO) throws AmetysRepositoryException {
        return newParent instanceof FormDirectory && !formOrFormDirectory.equals((Object)formDAO.getFormDirectoriesRootNode(siteName));
    }

    public static void moveTo(AmetysObject newParent, boolean renameIfExist, SimpleAmetysObject formOrFormDirectory) throws AmetysRepositoryException, RepositoryIntegrityViolationException {
        block6: {
            Node srcNode = formOrFormDirectory.getNode();
            Node targetNode = ((FormDirectory)newParent).getNode();
            try {
                if (formOrFormDirectory.getParent().equals((Object)newParent)) break block6;
                Object name = srcNode.getName();
                if (renameIfExist) {
                    int index = 1;
                    String origName = name;
                    while (targetNode.hasNode((String)name)) {
                        name = origName + "-" + index++;
                    }
                }
                String newPath = targetNode.getPath() + "/" + (String)name;
                Session session = srcNode.getSession();
                try {
                    session.move(srcNode.getPath(), newPath);
                }
                catch (ItemExistsException e) {
                    throw new AmetysRepositoryException("A form already exists for new path '" + newPath + "'", (Throwable)e);
                }
                session.save();
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException("Unable to move form '" + formOrFormDirectory + "' to node '" + newParent.getId() + "'", (Throwable)e);
            }
        }
    }

    public static void orderBefore(AmetysObject siblingNode, SimpleAmetysObject formOrFormDirectory) throws AmetysRepositoryException {
        throw new UnsupportedOperationException("Form ordering is not supported");
    }
}

