/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import org.ametys.plugins.forms.question.FormQuestionDataTypeExtensionPoint;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefaultElementDefinition;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.model.type.ModelItemType;
import org.ametys.runtime.parameter.Validator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormElementDefinitionHelper
implements Serviceable {
    protected static FormQuestionDataTypeExtensionPoint _formQuestionDataTypeExtensionPoint;
    protected static Logger __logger;

    public void service(ServiceManager manager) throws ServiceException {
        _formQuestionDataTypeExtensionPoint = (FormQuestionDataTypeExtensionPoint)((Object)manager.lookup(FormQuestionDataTypeExtensionPoint.ROLE));
    }

    public static ElementDefinition getElementDefinition(String name, String typeId, String labelKey, String descKey, Validator validator) {
        ModelItemType type = (ModelItemType)_formQuestionDataTypeExtensionPoint.getExtension(typeId);
        if (!(type instanceof ElementType)) {
            throw new BadItemTypeException("The type '" + typeId + "' (used for data '" + name + "') can not be used for an element definition.");
        }
        DefaultElementDefinition elementDefinition = new DefaultElementDefinition(name, false, (ElementType)type);
        if (StringUtils.isNotBlank((CharSequence)labelKey)) {
            elementDefinition.setLabel(new I18nizableText("plugin.forms", labelKey));
        }
        if (StringUtils.isNotBlank((CharSequence)descKey)) {
            elementDefinition.setDescription(new I18nizableText("plugin.forms", descKey));
        }
        if (validator != null) {
            elementDefinition.setValidator(validator);
        }
        return elementDefinition;
    }

    public static RepeaterDefinition getRepeaterDefinition(String datapath, ElementDefinition[] childElements, String labelKey, String descKey, String addKey, String deleteKey, Integer maxSize) {
        try {
            RepeaterDefinition repeater = RepeaterDefinition.of((String)datapath, (String)FormQuestionDataTypeExtensionPoint.ROLE, (ModelItem[])childElements);
            repeater.setLabel(new I18nizableText("plugin.forms", labelKey));
            repeater.setDescription(new I18nizableText("plugin.forms", descKey));
            repeater.setAddLabel(new I18nizableText("plugin.forms", addKey));
            repeater.setDeleteLabel(new I18nizableText("plugin.forms", deleteKey));
            repeater.setMaxSize(maxSize.intValue());
            return repeater;
        }
        catch (Exception e) {
            __logger.error("An error occured while creating repeater definition", (Throwable)e);
            return null;
        }
    }

    static {
        __logger = LoggerFactory.getLogger(FormElementDefinitionHelper.class);
    }
}

