/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.helper.FormMailHelper;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;

public class LimitedEntriesHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = LimitedEntriesHelper.class.getName();
    protected AmetysObjectResolver _resolver;
    protected FormMailHelper _formMailHelper;
    protected FormDAO _formDAO;
    protected CurrentUserProvider _currentUserProvider;
    protected ObservationManager _observationManager;
    protected FormEntryDAO _formEntryDAO;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._formMailHelper = (FormMailHelper)((Object)manager.lookup(FormMailHelper.ROLE));
        this._formDAO = (FormDAO)((Object)manager.lookup(FormDAO.ROLE));
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._formEntryDAO = (FormEntryDAO)((Object)manager.lookup(FormEntryDAO.ROLE));
    }

    @Callable(rights={""})
    public Map<String, Object> getLimitedEntriesProperties(String formId) {
        HashMap<String, Object> limitProperties = new HashMap<String, Object>();
        Form form = (Form)this._resolver.resolveById(formId);
        this._formDAO.checkHandleFormRight((AmetysObject)form);
        limitProperties.put("limit-to-one-entry-by-user", form.isLimitedToOneEntryByUser());
        limitProperties.put("limit-entries-enabled", form.isEntriesLimited());
        this._addOptionalProperty("max-entries", form.getMaxEntries(), limitProperties, null);
        this._addOptionalProperty("remaining-message", form.getRemainingMessage(), limitProperties, null);
        this._addOptionalProperty("closed-message", form.getClosedMessage(), limitProperties, null);
        limitProperties.put("queue-enabled", form.isQueueEnabled());
        this._addOptionalProperty("queue-size", form.getQueueSize(), limitProperties, null);
        this._addOptionalProperty("queue-closed-message", form.getClosedQueueMessage(), limitProperties, null);
        this._addOptionalProperty("queue-sender", form.getQueueMailSender(), limitProperties, Config.getInstance().getValue("smtp.mail.from"));
        this._addOptionalProperty("queue-receiver", form.getQueueMailReceiver(), limitProperties, "entry-user");
        this._addOptionalProperty("queue-subject", form.getQueueMailSubject(), limitProperties, null);
        this._addOptionalProperty("queue-body", form.getQueueMailBody(), limitProperties, null);
        return limitProperties;
    }

    private void _addOptionalProperty(String propertyName, Optional<? extends Object> value, Map<String, Object> limitProperties, Object defaultValue) {
        if (value.isPresent()) {
            limitProperties.put(propertyName, value.get());
        } else if (defaultValue != null) {
            limitProperties.put(propertyName, defaultValue);
        }
    }

    @Callable(rights={""})
    public Map<String, Object> setEntriesLimitProperties(Map<String, Object> limitParameters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Form form = (Form)this._resolver.resolveById((String)limitParameters.get("formId"));
        this._formDAO.checkHandleFormRight((AmetysObject)form);
        form.limitToOneEntryByUser((Boolean)limitParameters.get("limit-to-one-entry-by-user"));
        if (((Boolean)limitParameters.get("limit-entries-enabled")).booleanValue()) {
            form.limitEntries(true);
            form.setMaxEntries(((Integer)limitParameters.get("max-entries")).longValue());
            form.setRemainingMessage((String)limitParameters.get("remaining-message"));
            form.setClosedMessage((String)limitParameters.get("closed-message"));
            if (((Boolean)limitParameters.get("queue-enabled")).booleanValue()) {
                form.enableQueue(true);
                Object queueSize = limitParameters.get("queue-size");
                if (queueSize != null) {
                    form.setQueueSize(((Integer)queueSize).longValue());
                } else {
                    form.removeValue("queue-size");
                }
                form.setClosedQueueMessage((String)limitParameters.get("queue-closed-message"));
                form.setQueueMailtReceiver((String)limitParameters.get("queue-receiver"));
                form.setQueueMailSender((String)limitParameters.get("queue-sender"));
                form.setQueueMailSubject((String)limitParameters.get("queue-subject"));
                form.setQueueMailBody((String)limitParameters.get("queue-body"));
            } else {
                form.enableQueue(false);
            }
        } else {
            form.limitEntries(false);
        }
        form.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", form);
        this._observationManager.notify(new Event("form.modified", this._currentUserProvider.getUser(), eventParams));
        return result;
    }

    public boolean canUserSubmit(Form form, UserIdentity user, String clientIp) {
        if (form.isLimitedToOneEntryByUser() && this.hasUserAlreadyAnswer(form, user, clientIp)) {
            return false;
        }
        Optional<Long> maxEntriesOpt = form.getMaxEntries();
        if (form.isEntriesLimited() && maxEntriesOpt.isPresent()) {
            Optional<Long> queueSize = form.getQueueSize();
            int entriesSize = form.getActiveEntries().size();
            if (form.isQueueEnabled()) {
                return queueSize.isEmpty() || (long)entriesSize < maxEntriesOpt.get() + queueSize.get();
            }
            return (long)entriesSize < maxEntriesOpt.get();
        }
        return true;
    }

    public boolean hasUserAlreadyAnswer(Form form, UserIdentity user, String clientIp) {
        UserExpression additionalQuery = user != null ? new UserExpression("ametys-user", Expression.Operator.EQ, user) : (StringUtils.isNotBlank((String)clientIp) ? new StringExpression("ametys-ipAddress", Expression.Operator.EQ, clientIp) : null);
        return !this._formEntryDAO.getFormEntries(form, false, (Expression)additionalQuery, List.of()).isEmpty();
    }

    public String getClientIp(Request request) {
        String[] forwardedIps;
        String forwardedIp;
        String ip = "";
        String forwardedIpHeader = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotEmpty((String)forwardedIpHeader) && StringUtils.isNotBlank((String)(forwardedIp = (forwardedIps = forwardedIpHeader.split("[\\s,]+"))[forwardedIps.length - 1]))) {
            ip = forwardedIp.trim();
        }
        if (StringUtils.isBlank((String)ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public boolean isInQueue(FormEntry entry) {
        Form form = entry.getForm();
        return form.isQueueEnabled() && this._getQueue(form).contains((Object)entry);
    }

    public void deactivateEntry(String entryId) {
        FormEntry entryToDeactivate = (FormEntry)this._resolver.resolveById(entryId);
        if (entryToDeactivate.isActive().booleanValue()) {
            List<FormEntry> queue;
            Form form = entryToDeactivate.getForm();
            if (form.isQueueEnabled() && !(queue = this._getQueue(form)).isEmpty() && !queue.contains((Object)entryToDeactivate)) {
                this._formMailHelper.sendOutOfQueueMail(form, queue.get(0));
            }
            entryToDeactivate.setActive(false);
        }
    }

    protected List<FormEntry> _getQueue(Form form) {
        ArrayList<FormEntry> queuedEntries = new ArrayList<FormEntry>();
        Optional<Long> maxEntries = form.getMaxEntries();
        List<FormEntry> activeEntries = form.getActiveEntries();
        Collections.sort(activeEntries, Comparator.comparing(e -> e.getSubmitDate()));
        for (int i = maxEntries.get().intValue(); i < activeEntries.size(); ++i) {
            queuedEntries.add(activeEntries.get(i));
        }
        return queuedEntries;
    }

    public boolean isFormLimitIsReached(Form form) {
        Optional<Long> maxEntries = form.getMaxEntries();
        if (form.isEntriesLimited() && maxEntries.isPresent()) {
            List<FormEntry> activeEntries = form.getActiveEntries();
            return (long)activeEntries.size() >= maxEntries.get();
        }
        return false;
    }
}

