/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.data.ametysobject.DataAwareAmetysObject;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.type.DataContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public interface FormQuestionType {
    public String getId();

    public I18nizableText getLabel();

    public I18nizableText getDescription();

    public Integer getDisplayOrder();

    public String getIconGlyph();

    public List<ClientSideElement.ScriptFile> getScripts();

    public I18nizableText getCategory();

    public String getDisplayXSLT();

    public View getView(Form var1);

    public Model getModel();

    public Model getEntryModel(FormQuestion var1);

    public String getStorageType(FormQuestion var1);

    public I18nizableText getDefaultTitle();

    public void saxAdditionalInfos(ContentHandler var1, FormQuestion var2) throws SAXException;

    public void validateQuestionValues(Map<String, Object> var1, Map<String, I18nizableText> var2);

    public void validateEntryValues(FormQuestion var1, Map<String, Object> var2, Multimap<String, I18nizableText> var3, Optional<Long> var4, Map<String, Object> var5);

    public void doAdditionalOperations(FormQuestion var1, Map<String, Object> var2);

    public List<String> getFieldToDisableIfFormPublished(FormQuestion var1);

    public void saxEntryValue(ContentHandler var1, FormQuestion var2, FormEntry var3) throws SAXException;

    public boolean isQuestionConfigured(FormQuestion var1);

    default public String getJSRenderer(FormQuestion question) {
        return null;
    }

    default public String getJSConverter(FormQuestion question) {
        return null;
    }

    default public Object valueToJSONForClient(Object value, FormQuestion question, FormEntry entry, ModelItem modelItem) throws Exception {
        DataContext context = RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)entry).withDataPath(modelItem.getPath());
        return entry.dataToJSON(modelItem.getName(), context);
    }

    default public boolean onlyForDisplay(FormQuestion question) {
        return false;
    }

    default public boolean canBeAnsweredByUser(FormQuestion question) {
        return true;
    }

    default public boolean isCacheable(FormQuestion question) {
        return true;
    }
}

