/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.sources;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeEnumerator;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.search.Sort;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.model.SearchModel;
import org.ametys.cms.search.ui.model.SearchUIModel;
import org.ametys.cms.search.ui.model.SearchUIModelExtensionPoint;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.question.sources.AbstractSourceType;
import org.ametys.plugins.forms.question.sources.ChoiceOption;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Validator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class TableRefSourceType
extends AbstractSourceType {
    public static final String ATTRIBUTE_TABLE_REF_ID = "table-ref-id";
    protected Map<String, ModelItem> _tableRefSourceItems;
    protected ContentTypeExtensionPoint _cTypesEP;
    protected ContentSearcherFactory _searcherFactory;
    protected SearchUIModelExtensionPoint _searchUIModelExtensionPoint;
    private ServiceManager _manager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._searcherFactory = (ContentSearcherFactory)manager.lookup(ContentSearcherFactory.ROLE);
        this._cTypesEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._manager = manager;
    }

    @Override
    public Map<String, ModelItem> getModelItems() {
        this._tableRefSourceItems = new HashMap<String, ModelItem>();
        ElementDefinition contentTypes = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_TABLE_REF_ID, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_TABLE_REF_ID", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_TABLE_REF_ID_DESC", (Validator)new DefaultValidator(null, true));
        contentTypes.setEnumerator((Enumerator)new ContentTypeEnumerator());
        StaticEnumerator staticEnumerator = new StaticEnumerator();
        for (String typeId : this._cTypesEP.getExtensionsIds()) {
            ContentType contentType = (ContentType)this._cTypesEP.getExtension(typeId);
            if (!this._isTableRef(contentType)) continue;
            staticEnumerator.add(contentType.getLabel(), (Object)contentType.getId());
        }
        contentTypes.setEnumerator((Enumerator)staticEnumerator);
        this._tableRefSourceItems.put(contentTypes.getName(), (ModelItem)contentTypes);
        return this._tableRefSourceItems;
    }

    private boolean _isTableRef(ContentType cType) {
        return cType.isReferenceTable() && !cType.isAbstract() && !cType.isMixin();
    }

    @Override
    public List<ViewItem> getViewItems() {
        ArrayList<ViewItem> viewElements = new ArrayList<ViewItem>();
        ViewElement grid = new ViewElement();
        grid.setDefinition((ElementDefinition)this._tableRefSourceItems.get(ATTRIBUTE_TABLE_REF_ID));
        viewElements.add((ViewItem)grid);
        return viewElements;
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished() {
        List<String> fieldNames = super.getFieldToDisableIfFormPublished();
        fieldNames.add(ATTRIBUTE_TABLE_REF_ID);
        return fieldNames;
    }

    @Override
    public boolean remoteData() {
        return true;
    }

    @Override
    public I18nizableText getEntry(ChoiceOption value, Map<String, Object> contextParams) throws Exception {
        ContentValue contentValue = (ContentValue)value.getValue();
        try {
            String lang = (String)contextParams.get("lang");
            Locale locale = lang != null ? new Locale(lang) : null;
            ModifiableContent content = contentValue.getContent();
            return new I18nizableText(content.getTitle(locale));
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().warn("An error occured while getting label for reference table entry with id '" + contentValue.getContentId() + "' for question " + ((FormQuestion)((Object)contextParams.get("question"))).getName() + " : {}", (Object)e.getMessage());
            return new I18nizableText("plugin.forms", "PLUGINS_FORMS_ENTRY_UNKNOWN_TABLE_REF_CONTENT");
        }
    }

    @Override
    public Map<ChoiceOption, I18nizableText> getTypedEntries(Map<String, Object> contextParams) throws Exception {
        throw new UnsupportedOperationException("Method getTypedEntries can't be called for TableRefSourceType");
    }

    @Override
    public Map<ChoiceOption, I18nizableText> searchEntries(Map<String, Object> contextParams, int limit, Object paginationData) throws Exception {
        LinkedHashMap<ChoiceOption, I18nizableText> entries = new LinkedHashMap<ChoiceOption, I18nizableText>();
        FormQuestion question = this._getQuestionFromParam(contextParams);
        String tableRefId = (String)question.getValue(ATTRIBUTE_TABLE_REF_ID);
        int offset = paginationData != null ? ((Integer)paginationData - 1) * limit : 0;
        String pattern = (String)contextParams.get("pattern");
        String lang = (String)contextParams.get("lang");
        Boolean needSort = (Boolean)contextParams.getOrDefault("sort", false);
        String modelId = "reference-table-search-ui." + tableRefId;
        if (this._searchUIModelExtensionPoint == null) {
            this._searchUIModelExtensionPoint = (SearchUIModelExtensionPoint)this._manager.lookup(SearchUIModelExtensionPoint.ROLE);
        }
        SearchUIModel model = (SearchUIModel)this._searchUIModelExtensionPoint.getExtension(modelId);
        HashMap<String, CallSite> values = new HashMap<String, CallSite>();
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            values.put("metadata-title-search", (CallSite)((Object)("*" + pattern + "*")));
        }
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            param.put("language", lang);
        }
        Sort sort = needSort != false ? new Sort("title", Sort.Order.ASC) : null;
        AmetysObjectIterable results = this._searcherFactory.create((SearchModel)model).withSearchMode("simple").withSort(sort != null ? List.of(sort) : List.of()).withLimits(offset, limit).search(values, param);
        Locale locale = lang != null ? new Locale(lang) : null;
        for (Content content : results) {
            ChoiceOption choice = new ChoiceOption(content.getId());
            entries.put(choice, new I18nizableText(content.getTitle(locale)));
        }
        return entries;
    }

    @Override
    public String getStorageType(FormQuestion question) {
        return "content";
    }

    @Override
    public String getJSRenderer() {
        return "Ametys.plugins.forms.helper.SearchEntriesGridHelper.renderContentChoiceList";
    }

    @Override
    public String getJSConverter() {
        return "Ametys.plugins.forms.helper.SearchEntriesGridHelper.convertContent";
    }

    @Override
    public Object removeEmptyOrOtherValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            ArrayList<ContentValue> newVal = new ArrayList<ContentValue>();
            for (ContentValue val : (ContentValue[])value) {
                if (!StringUtils.isNotBlank((CharSequence)val.getContentId()) || val.getContentId().equals("__internal_other")) continue;
                newVal.add(val);
            }
            if (newVal.isEmpty()) {
                return null;
            }
            return newVal.toArray(new ContentValue[newVal.size()]);
        }
        if (StringUtils.isNotBlank((CharSequence)((ContentValue)value).getContentId()) && !((ContentValue)value).getContentId().equals("__internal_other")) {
            return value;
        }
        return null;
    }

    @Override
    public Object valueToJSONForClient(Object value, FormQuestion question, FormEntry entry, ModelItem modelItem) throws Exception {
        return this._getComputedComplexValue(value, question, entry);
    }

    @Override
    public String value2String(Object value) {
        if (value instanceof ContentValue) {
            ContentValue content = (ContentValue)value;
            return content.getContentId();
        }
        return super.value2String(value);
    }
}

