/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.types;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.question.types.AbstractFormQuestionType;
import org.ametys.plugins.forms.question.types.AutocompleteAwareQuestionType;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Validator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SimpleTextQuestionType
extends AbstractFormQuestionType
implements AutocompleteAwareQuestionType {
    public static final String ATTRIBUTE_REGEXP = "regexp";
    public static final String ATTRIBUTE_CUSTOM_REGEX = "custom-regex";
    public static final String ATTRIBUTE_AUTOFILL = "autofill";
    public static final String ATTRIBUTE_DEFAULT_VALUE = "default-value";
    public static final String EMPTY_REGEX_VALUE = " ";
    public static final String EMAIL_REGEX_VALUE = "email";
    public static final String PHONE_REGEX_VALUE = "phone";
    public static final String CUSTOM_REGEX_VALUE = "custom";
    public static final String EMPTY_AUTOFILL_VALUE = " ";
    public static final String EMAIL_AUTOFILL_VALUE = "email";
    public static final String ID_AUTOFILL_VALUE = "id";
    public static final String FULLNAME_AUTOFILL_VALUE = "fullName";
    public static final String FIRSTNAME_AUTOFILL_VALUE = "firstName";
    public static final String LASTNAME_AUTOFILL_VALUE = "lastName";
    public static final String CUSTOM_AUTOFILL_VALUE = "custom";
    public static final String ATTRIBUTE_PLACEHOLDER = "placeholder";
    public static final String DEFAULT_TITLE = "PLUGIN_FORMS_QUESTION_DEFAULT_TITLE_SIMPLE_TEXT";
    protected CurrentUserProvider _currentUserProvider;
    protected UserManager _userManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
    }

    @Override
    protected List<ModelItem> _getModelItems() {
        List<ModelItem> modelItems = super._getModelItems();
        ElementDefinition placeholder = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_PLACEHOLDER, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_PLACEHOLDER", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_PLACEHOLDER_DESC", null);
        modelItems.add((ModelItem)placeholder);
        ElementDefinition autofill = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_AUTOFILL, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_DESC", null);
        StaticEnumerator autofillStaticEnumerator = new StaticEnumerator();
        autofillStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_EMPTY_TEXT"), (Object)" ");
        autofillStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_EMAIL"), (Object)"email");
        autofillStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_ID"), (Object)ID_AUTOFILL_VALUE);
        autofillStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_FULLNAME"), (Object)FULLNAME_AUTOFILL_VALUE);
        autofillStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_FIRSTNAME"), (Object)FIRSTNAME_AUTOFILL_VALUE);
        autofillStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_LASTNAME"), (Object)LASTNAME_AUTOFILL_VALUE);
        autofillStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_CUSTOM"), (Object)"custom");
        autofill.setEnumerator((Enumerator)autofillStaticEnumerator);
        HashMap<String, I18nizableText> widgetParameters = new HashMap<String, I18nizableText>();
        widgetParameters.put("naturalOrder", new I18nizableText("true"));
        autofill.setWidgetParameters(widgetParameters);
        autofill.setDefaultValue((Object)" ");
        modelItems.add((ModelItem)autofill);
        ElementDefinition defaultValue = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_DEFAULT_VALUE, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_DEFAULT_VALUE", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_DEFAULT_VALUE_DESC", null);
        DisableConditions disableConditions = new DisableConditions();
        DisableCondition condition = new DisableCondition(ATTRIBUTE_AUTOFILL, DisableCondition.OPERATOR.NEQ, "custom");
        disableConditions.getConditions().add(condition);
        defaultValue.setDisableConditions(disableConditions);
        modelItems.add((ModelItem)defaultValue);
        ElementDefinition regexp = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_REGEXP, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_DESC", null);
        StaticEnumerator regexStaticEnumerator = new StaticEnumerator();
        regexStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_EMPTY_TEXT"), (Object)" ");
        regexStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_EMAIL"), (Object)"email");
        regexStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_PHONE"), (Object)PHONE_REGEX_VALUE);
        regexStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_CUSTOM"), (Object)"custom");
        regexp.setEnumerator((Enumerator)regexStaticEnumerator);
        HashMap<String, I18nizableText> regexpWidgetParameters = new HashMap<String, I18nizableText>();
        regexpWidgetParameters.put("naturalOrder", new I18nizableText("true"));
        regexp.setWidgetParameters(regexpWidgetParameters);
        regexp.setDefaultValue((Object)" ");
        modelItems.add((ModelItem)regexp);
        ElementDefinition customRegex = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_CUSTOM_REGEX, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_CUSTOM", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_CUSTOM_DESC", (Validator)new DefaultValidator("^\\/.+\\/[gi]*$", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_REGEXP_ERROR_DESCRIPTION"), false));
        DisableConditions regexDisableConditions = new DisableConditions();
        DisableCondition regexCondition = new DisableCondition(ATTRIBUTE_REGEXP, DisableCondition.OPERATOR.NEQ, "custom");
        regexDisableConditions.getConditions().add(regexCondition);
        customRegex.setDisableConditions(regexDisableConditions);
        modelItems.add((ModelItem)customRegex);
        modelItems.add(this.getAutocompleteModelItem(AutocompleteAwareQuestionType.InputType.TEXT));
        return modelItems;
    }

    @Override
    protected SimpleViewItemGroup _getAdvancedTab() {
        SimpleViewItemGroup advancedFieldset = super._getAdvancedTab();
        ViewElement placeholder = new ViewElement();
        placeholder.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_PLACEHOLDER));
        advancedFieldset.addViewItem((ViewItem)placeholder);
        ViewElement autofill = new ViewElement();
        autofill.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_AUTOFILL));
        advancedFieldset.addViewItem((ViewItem)autofill);
        ViewElement defaultValue = new ViewElement();
        defaultValue.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_DEFAULT_VALUE));
        advancedFieldset.addViewItem((ViewItem)defaultValue);
        ViewElement regexp = new ViewElement();
        regexp.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_REGEXP));
        advancedFieldset.addViewItem((ViewItem)regexp);
        ViewElement customRegex = new ViewElement();
        customRegex.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_CUSTOM_REGEX));
        advancedFieldset.addViewItem((ViewItem)customRegex);
        advancedFieldset.addViewItem((ViewItem)this.getAutocompleteViewElement(this.getModel()));
        return advancedFieldset;
    }

    @Override
    public String getStorageType(FormQuestion question) {
        return "string";
    }

    @Override
    protected ModelItem _getEntryModelItem(FormQuestion question) {
        ModelItem item = super._getEntryModelItem(question);
        ((ElementDefinition)item).setValidator((Validator)new DefaultValidator(this._getEntryRegExpPattern(question), this.isMandatory(question)));
        return item;
    }

    @Override
    public void saxAdditionalInfos(ContentHandler contentHandler, FormQuestion question) throws SAXException {
        super.saxAdditionalInfos(contentHandler, question);
        if (StringUtils.isEmpty((String)((String)question.getValue(ATTRIBUTE_DEFAULT_VALUE)))) {
            String autofill;
            UserIdentity userIdentity = this._currentUserProvider.getUser();
            User user = userIdentity != null ? this._userManager.getUser(userIdentity) : null;
            String string = autofill = user != null ? this._getAutofillValue(question, user) : null;
            if (StringUtils.isNotBlank((String)autofill)) {
                XMLUtils.createElement((ContentHandler)contentHandler, (String)ATTRIBUTE_DEFAULT_VALUE, (String)autofill);
            }
        } else {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)ATTRIBUTE_DEFAULT_VALUE, (String)((String)question.getValue(ATTRIBUTE_DEFAULT_VALUE)));
        }
        String pattern = this._getRegExpPattern(question);
        if (StringUtils.isNotEmpty((String)pattern)) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"pattern", (String)pattern);
        }
    }

    protected String _getAutofillValue(FormQuestion question, User user) {
        String autofill = (String)question.getValue(ATTRIBUTE_AUTOFILL);
        if (autofill != null) {
            switch (autofill) {
                case "email": {
                    return user.getEmail();
                }
                case "id": {
                    return user.getIdentity().getLogin();
                }
                case "fullName": {
                    return user.getFullName();
                }
                case "firstName": {
                    return user.getFirstName();
                }
                case "lastName": {
                    return user.getLastName();
                }
            }
            return null;
        }
        return null;
    }

    protected String _getRegExpPattern(FormQuestion question) {
        String regexpType = (String)question.getValue(ATTRIBUTE_REGEXP);
        if (regexpType == null) {
            return null;
        }
        if ("email".equals(regexpType)) {
            return "/^([a-zA-Z0-9_\\.\\-\\+])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$/";
        }
        if (PHONE_REGEX_VALUE.equals(regexpType)) {
            return "/^(\\+?\\(?[0-9]{1,3}\\)?([\\s]?)(\\(0\\))?|0)([\\s]?)([0-9\\-\\+\\s]{4,})+$/";
        }
        if ("custom".equals(regexpType) && !"".equals(question.getValue(ATTRIBUTE_CUSTOM_REGEX))) {
            return (String)question.getValue(ATTRIBUTE_CUSTOM_REGEX);
        }
        return null;
    }

    protected String _getEntryRegExpPattern(FormQuestion question) {
        String regexpType = (String)question.getValue(ATTRIBUTE_REGEXP);
        if (regexpType == null) {
            return null;
        }
        if ("email".equals(regexpType)) {
            return "^([a-zA-Z0-9_\\.\\-\\+])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$";
        }
        if (PHONE_REGEX_VALUE.equals(regexpType)) {
            return "^(\\+?\\(?[0-9]{1,3}\\)?([\\s]?)(\\(0\\))?|0)([\\s]?)([0-9\\-\\+\\s]{4,})+$";
        }
        if ("custom".equals(regexpType) && !"".equals(question.getValue(ATTRIBUTE_CUSTOM_REGEX))) {
            String custom = (String)question.getValue(ATTRIBUTE_CUSTOM_REGEX);
            return custom.substring(1, custom.length() - 1);
        }
        return null;
    }

    @Override
    public void validateQuestionValues(Map<String, Object> values, Map<String, I18nizableText> errors) {
        super.validateQuestionValues(values, errors);
        if (StringUtils.isNotBlank((String)((String)values.get(ATTRIBUTE_CUSTOM_REGEX))) && !Pattern.matches("^\\/.+\\/[gi]*$", (CharSequence)values.get(ATTRIBUTE_CUSTOM_REGEX))) {
            errors.put(ATTRIBUTE_CUSTOM_REGEX, new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_REGEXP_ERROR_DESCRIPTION"));
        }
    }

    @Override
    public I18nizableText getDefaultTitle() {
        return new I18nizableText("plugin.forms", DEFAULT_TITLE);
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished(FormQuestion question) {
        List<String> fieldNames = super.getFieldToDisableIfFormPublished(question);
        fieldNames.add(ATTRIBUTE_REGEXP);
        fieldNames.add(ATTRIBUTE_CUSTOM_REGEX);
        return fieldNames;
    }

    @Override
    public boolean isCacheable(FormQuestion question) {
        return StringUtils.isBlank((String)((String)question.getValue(ATTRIBUTE_AUTOFILL))) || question.getValue(ATTRIBUTE_AUTOFILL) == "custom";
    }
}

