/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.validators;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.ValidationResult;

public abstract class AbstractIntervalFormValidator<T>
extends DefaultValidator {
    protected T _min;
    protected T _max;

    public AbstractIntervalFormValidator(String regexp, boolean mandatory, T min, T max) {
        super(regexp, mandatory);
        this._min = min;
        this._max = max;
    }

    protected ValidationResult validateSingleValue(Object value) {
        ValidationResult result = super.validateSingleValue(value);
        if (value != null) {
            if (this._min != null && this.isLessThan(value, this._min)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Entry '" + value + "' is invalid : " + this._min + " is greater than " + value);
                }
                result.addError(this.getIntervalError(this._min, this._max));
            }
            if (this._max != null && this.isMoreThan(value, this._max)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Entry '" + value + "' is invalid : " + this._max + " is smaller than " + value);
                }
                result.addError(this.getIntervalError(this._min, this._max));
            }
        }
        return result;
    }

    protected ValidationResult validateArrayValues(Object[] values) {
        ValidationResult result = super.validateArrayValues(values);
        for (Object valueToValidate : values) {
            result.addResult(this.validateSingleValue(valueToValidate));
        }
        return result;
    }

    protected abstract boolean isLessThan(T var1, T var2);

    protected abstract boolean isMoreThan(T var1, T var2);

    protected abstract I18nizableText getIntervalError(T var1, T var2);
}

