/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.statistics;

import java.util.List;
import java.util.stream.IntStream;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugins.admin.statistics.Statistics;
import org.ametys.runtime.plugins.admin.statistics.StatisticsNode;
import org.ametys.runtime.plugins.admin.statistics.StatisticsProvider;
import org.ametys.runtime.plugins.admin.statistics.StatisticsValue;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class FormsStatisticsProvider
implements StatisticsProvider,
Serviceable,
PluginAware {
    protected AmetysObjectResolver _resolver;
    private String _id;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    public Statistics getStatistics() {
        List<Integer> formsSubmissions = this._getFormsSubmissions();
        int submissions = formsSubmissions.stream().flatMapToInt(IntStream::of).sum();
        return new StatisticsNode(this._id, new I18nizableText("plugin.forms", "PLUGINS_FORMS_STATISTICS_FORMS_LABEL"), "ametysicon-code-html-form", (Object)formsSubmissions.size(), List.of(new StatisticsNode("submissions", new I18nizableText("plugin.forms", "PLUGINS_FORMS_STATISTICS_FORMS_SUBMISSIONS_LABEL"), "ametysicon-desktop-school-tool", (Object)submissions, List.of(new StatisticsValue("max", new I18nizableText("plugin.forms", "PLUGINS_FORMS_STATISTICS_FORMS_SUBMISSIONS_MAX_LABEL"), "ametysicon-sort51", (Object)(formsSubmissions.size() > 0 ? formsSubmissions.get(formsSubmissions.size() - 1) : 0)), new StatisticsValue("median", new I18nizableText("plugin.forms", "PLUGINS_FORMS_STATISTICS_FORMS_SUBMISSIONS_MEDIAN_LABEL"), "ametysicon-maths-window-symbol-x", (Object)(formsSubmissions.size() > 0 ? formsSubmissions.get(formsSubmissions.size() / 2) : 0))), false)), true);
    }

    private List<Integer> _getFormsSubmissions() {
        String xpathQuery = "//element(*, ametys:form)";
        return this._resolver.query(xpathQuery).stream().filter(Form.class::isInstance).map(Form.class::cast).map(Form::getEntries).map(List::size).sorted().toList();
    }
}

