/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the representation of a Form.
 * @private
 */
Ext.define("Ametys.plugins.forms.Form", 
	{
		config: {
			/**
			 * @cfg {String} id The unique id of the form
			 */
			/**
			 * @method getId Get the #cfg-id
			 * @return {String} The id
			 */
			/** @ignore */
			id: null,
			/**
             * @cfg {String} name The name of the form
             */
            /**
             * @method getName Get the #cfg-name
             * @return {String} The name
             */
            /** @ignore */
            name: null,
			/**
			 * @cfg {String} title The title of the form
			 */
			/**
			 * @method getTitle Get the #cfg-title
			 * @return {String} The title
			 */
			/** @ignore */
			title: null,
			/**
             * @cfg {String} fullPath The full path of the form
             */
            /**
             * @method getFullPath Get the #cfg-fullPath
             * @return {String} The full path
             */
            /** @ignore */
            fullPath: null,
            /**
             * @cfg {Boolean} isPublished true if the form is published on a page
             */
            /**
             * @method getIsPublished Get the #cfg-isPublished
             * @return {Boolean} true if the form is published
             */
            /** @ignore */
            isPublished: false,
            /**
             * @cfg {Object[]} pages the pages where the form is published
             */
            /**
             * @method getPages Get the #cfg-pages
             * @return {Object[]} The pages
             */
            /** @ignore */
            pages: null,
            /**
             * @cfg {Boolean} hasEntries true if the form has at least one entry
             */
            /**
             * @method getHasEntries Get the #cfg-hasEntries
             * @return {Boolean} true if the form has at least one entry
             */
            /** @ignore */
            hasEntries: false,
            /**
             * @cfg {Number} nbEntries the number of active entries
             */
            /**
             * @method getNbEntries Get the #cfg-nbEntries
             * @return {Number} The number of active entries
             */
            /** @ignore */
            nbEntries: null,
            /**
             * @cfg {Boolean} hasChildren true if the form has at least one page
             */
            /**
             * @method getHasChildren Get the #cfg-hasChildren
             * @return {Boolean} true if the form has at least one page
             */
            /** @ignore */
            hasChildren: false,
            /**
             * @cfg {String} workflowName The form workflow name
             */
            /**
             * @method getWorkflowName Get the #cfg-workflowName
             * @return {String} The form workflow name
             */
            /** @ignore */
            workflowName: null,
            /**
             * @cfg {String} parentId The form parent id
             */
            /**
             * @method getParentId Get the #cfg-parentId
             * @return {String} The form parent id
             */
            /** @ignore */
            parentId: null,
            /**
             * @cfg {Boolean} isLimitedToOneEntryByUser true if the form is limited to one entry by user
             */
            /**
             * @method getIsLimitedToOneEntryByUser Get the #cfg-isLimitedToOneEntryByUser
             * @return {Boolean} true if the form is limited to one entry by user
             */
            /** @ignore */
            isLimitedToOneEntryByUser: false,
            /**
             * @cfg {Boolean} isEntriesLimited true if the form has a limited number of entry
             */
            /**
             * @method getIsEntriesLimited Get the #cfg-isEntriesLimited
             * @return {Boolean} true if the form if the form has a limited number of entry
             */
            /** @ignore */
            isEntriesLimited: false,
            /**
             * @cfg {Number} maxEntries the max of form entries
             */
            /**
             * @method getMaxEntries Get the #cfg-maxEntries
             * @return {Number} The max of form entries
             */
            /** @ignore */
            maxEntries: null,
            /**
             * @cfg {Boolean} isQueueEnabled true if the form has a queue
             */
            /**
             * @method getIsQueueEnabled Get the #cfg-isQueueEnabled
             * @return {Boolean} true if the form if the form has a queue
             */
            /** @ignore */
            isQueueEnabled: false,
            /**
             * @cfg {Number} queueSize the queue size
             */
            /**
             * @method getQueueSize Get the #cfg-queueSize
             * @return {Number} The queue size
             */
            /** @ignore */
            queueSize: null,
            /**
             * @cfg {String} scheduleStatus The form schedule status
             */
            /**
             * @method getScheduleStatus Get the #cfg-scheduleStatus
             * @return {String} The form schedule status
             */
            /** @ignore */
            scheduleStatus: null,
            /**
             * @cfg {String} startDate The form start date
             */
            /**
             * @method getStartDate Get the #cfg-startDate
             * @return {String} The form start date
             */
            /** @ignore */
            startDate: null,
            /**
             * @cfg {String} endDate The form end date
             */
            /**
             * @method getEndDate Get the #cfg-endDate
             * @return {String} The form end date
             */
            /** @ignore */
            endDate: null,
            /**
             * @cfg {Boolean} isConfigured True if the form is well configured
             */
            /**
             * @method getIsConfigured Get the #cfg-isConfigured
             * @return {Boolean} True if the form is well configured
             */
            /** @ignore */
            isConfigured: false,
            /**
             * @cfg {Boolean} receiptAcknowledgement True if the form has a receipt acknowledgement
             */
            /**
             * @method getReceiptAcknowledgement Get the #cfg-receiptAcknowledgement
             * @return {Boolean} True if the form has a receipt acknowledgement
             */
            /** @ignore */
            receiptAcknowledgement: false,
            /**
             * @method getAdminEmails Get the #cfg-adminEmails
             * @return {Boolean} True if the form has admin emails enabled
             */
            /** @ignore */
            adminEmails: false,
			/**
             * @cfg {String[]} rights List of the id of the rights the current user have on this form
             */
            /**
             * @method getRights Get the #cfg-rights
             * @return {String[]} The rights
             */
            /** @ignore */
            rights: [],
            /**
             * @cfg {Boolean} isAnonymous True if the form is in anonymous access
             */
            /**
             * @method getIsAnonymous Get the #cfg-isAnonymous
             * @return {Boolean} True if the form is in anonymous access
             */
            /** @ignore */
            isAnonymous: false,
            /**
             * @cfg {Boolean} canEditRight True if the user can edit form rights
             */
            /**
             * @method getCanEditRight Get the #cfg-canEditRight
             * @return {Boolean} True if the user can edit form rights
             */
            /** @ignore */
            canEditRight: false
		},
		
		
		/**
		 * Creates a content instance
		 * @param {Object} config See configuration doc.
		 */
		constructor: function (config)
		{
			this.initConfig(config);
		},
		
		/**
		 * Get the form's properties
		 * @return {Object} initialProperty The initial form's properties
		 */
		getProperties: function (initialProperty)
		{
            initialProperty = initialProperty || {};
            
            return Ext.apply ({
                    id: this._id,
                    name: this._name,
                    title: this._title,
                    fullPath: this._fullPath,
                    isPublished: this._isPublished,
                    pages: this._pages,
                    hasEntries: this._hasEntries,
                    nbEntries: this._nbEntries,
                    hasChildren: this._hasChildren,
                    workflowName: this._workflowName,
                    parentId: this._parentId,
                    isLimitedToOneEntryByUser: this._isLimitedToOneEntryByUser,
                    isEntriesLimited: this._isEntriesLimited,
                    maxEntries: this._maxEntries,
                    isQueueEnabled: this._isQueueEnabled,
                    queueSize: this._queueSize,
                    scheduleStatus: this._scheduleStatus,
                    startDate: this._startDate,
                    endDate: this._endDate,
                    isConfigured: this._isConfigured,
                    receiptAcknowledgement: this._receiptAcknowledgement,
                    adminEmails: this._adminEmails,
                    rights: this._rights,
                    isAnonymous: this._isAnonymous,
                    canEditRight: this._canEditRight
                }, initialProperty
            );
		},
		
		/**
         * True if the current user have the right to handle form
         * @return {Boolean} True if the current user have the right to handle form
         */
		canWrite: function()
		{
            return this._rights.indexOf("Plugins_Forms_Right_Handle") != -1;
        }
	}
);
