/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.ametys.web.cache.pageelement.AbstractSimplePageElementCachePolicy;
import org.ametys.web.cache.pageelement.PageElementCachePolicy;

/**
 * {@link PageElementCachePolicy} for the form display service.
 */
public class FormDisplayServiceCachePolicy extends AbstractSimplePageElementCachePolicy
{
    
    private static final Set<String> _TYPES = new HashSet<>();
    static
    {
        _TYPES.add("SERVICE:org.ametys.forms.service.Display");
    }
    
    @Override
    public Set<String> getPageElementTypes()
    {
        return _TYPES;
    }
    
    @Override
    protected List<String> _getRemovingCacheEventIds(String workspace)
    {
        return Arrays.asList(FormEvents.FORM_MODIFIED, FormEvents.FORM_DELETED);
    }
    
}
