/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.content.processing;

/**
 * Forms constants.
 */
public final class FormValidators
{
    
    private FormValidators()
    {
        // Hides the default constructor.
    }
    
    /**
     * Get the integer validation pattern.
     * @return the integer validation pattern.
     */
    public static final String getIntegerPattern()
    {
        return "^-?[0-9]+$";
    }
    
    /**
     * Get the float validation pattern.
     * @return the float validation pattern.
     */
    public static final String getFloatPattern()
    {
        return "^-?[0-9]+(\\.[0-9]+)?$";
    }
    
    /**
     * Get the date validation pattern.
     * @return the date validation pattern.
     */
    public static final String getDatePattern()
    {
        return "^([12][0-9][0-9][0-9])-([01][0-9])-([0123][0-9])$";
    }
    
    /**
     * Get the time validation pattern.
     * @return the time validation pattern.
     */
    public static final String getTimePattern()
    {
        return "^([012][0-9]):([012345][0-9])$";
    }
    
    /**
     * Get the date and time validation pattern.
     * @return the date and time validation pattern.
     */
    public static final String getDateTimePattern()
    {
        return "^([12][0-9][0-9][0-9])-([01][0-9])-([0123][0-9])[ T]([012][0-9]):([012345][0-9])$";
    }
    
    /**
     * Get the phone validation pattern.
     * @return the phone validation pattern.
     */
    public static final String getPhonePattern()
    {
        return "^(\\+?\\(?[0-9]{1,3}\\)?([\\s]?)(\\(0\\))?|0)([\\s]?)([0-9\\-\\+\\s]{4,})+$";
    }
    
    /**
     * Get the date format pattern (understandable by java.util.SimpleDateFormat).
     * @return the date format pattern.
     */
    public static final String getDateFormat()
    {
        return "yyyy-MM-dd";
    }
    
    /**
     * Get the time format pattern (understandable by java.util.SimpleDateFormat).
     * @return the time format pattern.
     */
    public static final String getTimeFormat()
    {
        return "HH:mm";
    }
    
    /**
     * Get the date and time format pattern (understandable by java.util.SimpleDateFormat).
     * @return the date and time format pattern.
     */
    public static final String getDateTimeFormat()
    {
        return "yyyy-MM-dd HH:mm";
    }
    
}
