/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.workflow;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.RibbonControlsManager;
import org.ametys.core.ui.RibbonManagerCache;
import org.ametys.plugins.forms.menu.FormWorkflowButtonMenu;
import org.ametys.plugins.workflow.ObservationConstants;

/**
 * {@link Observer} for observing workflow saved event and reset the workflow buttons
 */
public class FormWorkflowRibbonObserver implements Observer, Serviceable
{
    /** The ribbon controls manager */
    protected RibbonControlsManager _ribbonControlsManager;
    
    /** The ribbon manager cache */
    protected RibbonManagerCache _ribbonManagerCache;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _ribbonControlsManager = (RibbonControlsManager) manager.lookup(RibbonControlsManager.ROLE);
        _ribbonManagerCache = (RibbonManagerCache) manager.lookup(RibbonManagerCache.ROLE);
    }
    
    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_WORKFLOW_SAVED);
    }

    public int getPriority(Event event)
    {
        return 0;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        ClientSideElement extension = _ribbonControlsManager.getExtension(FormWorkflowButtonMenu.BUTTON_EXTENSION_ID);
        if (extension instanceof FormWorkflowButtonMenu formWorkflowButtonMenu)
        {
            formWorkflowButtonMenu.reset();
        }
        
        _ribbonManagerCache.invalidate();
    }

}
