/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Map;
import org.ametys.plugins.forms.FormErrors;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FormErrorsGenerator
extends AbstractGenerator {
    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Form form = (Form)((Object)request.getAttribute("form"));
        FormErrors errors = new FormErrors((Multimap<String, I18nizableText>)((Multimap)request.getAttribute("form-errors")));
        Multimap<String, I18nizableText> errorMap = errors.getErrors();
        this.contentHandler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", form.getId());
        atts.addCDATAAttribute("title", form.getTitle());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"form-errors", (Attributes)atts);
        for (Map.Entry fieldErrors : errorMap.entries()) {
            String errorName = (String)fieldErrors.getKey();
            I18nizableText message = (I18nizableText)fieldErrors.getValue();
            if (StringUtils.isEmpty((String)errorName) || "form-access".equals(errorName) || "entries-limit-reached".equals(errorName) || "scheduled-not-open".equals(errorName)) {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"form-access");
                message.toSAX(this.contentHandler, "error");
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"form-access");
                continue;
            }
            if ("ametys-captcha".equals(errorName)) {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"captcha");
                message.toSAX(this.contentHandler, "error");
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"captcha");
                continue;
            }
            FormQuestion question = form.getQuestion(errorName);
            atts.clear();
            atts.addCDATAAttribute("id", question.getId());
            atts.addCDATAAttribute("name", errorName);
            atts.addCDATAAttribute("title", question.getTitle());
            atts.addCDATAAttribute("type", question.getType().getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"question", (Attributes)atts);
            message.toSAX(this.contentHandler, "error");
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"question");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"form-errors");
        this.contentHandler.endDocument();
    }
}

