/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.ametys.core.observation.Event;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.web.cache.AbstractSiteCacheObserver;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class InvalidateCacheOnFormModifiedObserver
extends AbstractSiteCacheObserver {
    protected FormDAO _formDAO;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._formDAO = (FormDAO)((Object)manager.lookup(FormDAO.ROLE));
    }

    public boolean supports(Event event) {
        return event.getId().equals("form.modified");
    }

    protected void _internalObserve(Event event, Site site, Session liveSession) throws Exception {
        Map args = event.getArguments();
        if (args.containsKey("form")) {
            Form form = (Form)((Object)args.get("form"));
            for (ModifiableZoneItem zoneItem : this._formDAO.getFormZoneItems(form.getId(), form.getSiteName())) {
                ModifiablePage page;
                JCRAmetysObject jcrPage;
                Node pageNode;
                SitemapElement sitemapElement = zoneItem.getZone().getSitemapElement();
                if (!(sitemapElement instanceof JCRAmetysObject) || !(sitemapElement instanceof ModifiablePage) || !liveSession.itemExists((pageNode = (jcrPage = (JCRAmetysObject)(page = (ModifiablePage)sitemapElement)).getNode()).getPath())) continue;
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("Form modified: " + event + ", invalidating cache");
                }
                this._cachePolicy.invalidateCacheOnPageModification((Page)page);
            }
        }
    }

    protected Site _getSite(Event event) {
        Map args = event.getArguments();
        if (args.containsKey("form")) {
            Form form = (Form)((Object)args.get("form"));
            return form.getSite();
        }
        return null;
    }
}

