/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.Field;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.StringUtils;

public class FormPropertiesManager
extends AbstractLogEnabled
implements Serviceable,
Component,
PluginAware {
    public static final Pattern OPTION_VALUE_PATTERN = Pattern.compile("^option-([0-9]+)-value$");
    public static final String ROLE = FormPropertiesManager.class.getName();
    public static final String ROOT_REPO = "ametys:root";
    public static final String PLUGINS_NODE = "ametys-internal:plugins";
    public static final String FORMS_NODE = "ametys-internal:forms";
    public static final String LANGUAGE_PROPERTY = "ametys-internal:language";
    public static final String SITE_PROPERTY = "ametys:site";
    public static final String FORM_PROPERTY_ID = "ametys:id";
    public static final String FORM_PROPERTY_LABEL = "ametys:label";
    public static final String FORM_PROPERTY_RECEIPT_FIELD_ID = "ametys:receipt-field-id";
    public static final String FORM_PROPERTY_RECEIPT_FROM_ADDRESS = "ametys:receipt-from-address";
    public static final String FORM_PROPERTY_RECEIPT_SUBJECT = "ametys:receipt-subject";
    public static final String FORM_PROPERTY_RECEIPT_BODY = "ametys:receipt-body";
    public static final String FORM_PROPERTY_REDIRECT_TO = "ametys:redirect-to";
    public static final String FORM_PROPERTY_EMAILS = "ametys:notification-emails";
    public static final String FORM_PROPERTY_WORKFLOW_NAME = "ametys:workflow-name";
    public static final String FIELD_PROPERTY_ID = "ametys:id";
    public static final String FIELD_PROPERTY_TYPE = "ametys:type";
    public static final String FIELD_PROPERTY_NAME = "ametys:name";
    public static final String FIELD_PROPERTY_LABEL = "ametys:label";
    public static final String FIELD_PROPERTY_PREFIX = "ametys:property-";
    public static final String FORM_PROPERTY_LIMIT = "ametys:limit";
    public static final String FORM_PROPERTY_REMAINING_PLACES = "ametys:remaining-places";
    public static final String FORM_PROPERTY_NO_REMAINING_PLACES = "ametys:no-remaining-places";
    protected Repository _repository;
    protected SiteManager _siteManager;
    protected AmetysObjectResolver _resolver;
    protected String _pluginName;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._repository = (Repository)serviceManager.lookup("javax.jcr.Repository");
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public Form getForm(String id) throws FormsException {
        return this.getForm(null, id);
    }

    public Form getForm(String siteName, String id) throws FormsException {
        Session session = null;
        try {
            session = this._repository.login();
            Form form = null;
            Object xpathQuery = "//element(*, ametys:content)";
            if (siteName != null) {
                xpathQuery = (String)xpathQuery + "[@ametys:site='" + siteName + "']";
            }
            xpathQuery = (String)xpathQuery + "/ametys-internal:forms/*[@ametys:id = '" + id + "']";
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery((String)xpathQuery, "xpath");
            NodeIterator nodeIterator = query.execute().getNodes();
            if (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                form = this._extractForm(node);
            }
            Form form2 = form;
            return form2;
        }
        catch (RepositoryException e) {
            throw new FormsException("Error executing the query to find the form of id " + id, e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getMostRecentFormFrozenContent(String formId) throws FormsException {
        Session session = null;
        try {
            session = this._repository.login();
            String xpathQuery = "//element(" + formId + ", nt:frozenNode)/../.. order by @ametys:lastModified descending";
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(xpathQuery, "xpath");
            NodeIterator nodeIterator = query.execute().getNodes();
            if (nodeIterator.hasNext()) {
                Node node = (Node)nodeIterator.next();
                return node;
            }
            Node node = null;
            return node;
        }
        catch (RepositoryException e) {
            this.getLogger().error("Error executing the query to find the frozen content nodes for the form '" + formId + "'.", (Throwable)e);
            Node node = null;
            return node;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public List<Form> getForms(Content content) throws FormsException {
        Session session = null;
        try {
            Node contentNode;
            ArrayList<Form> forms = new ArrayList<Form>();
            session = this._repository.login();
            if (content instanceof JCRAmetysObject && (contentNode = ((JCRAmetysObject)content).getNode()).hasNode(FORMS_NODE)) {
                Node formsNode = contentNode.getNode(FORMS_NODE);
                NodeIterator nodes = formsNode.getNodes();
                while (nodes.hasNext()) {
                    Node node = nodes.nextNode();
                    Form form = this._extractForm(node);
                    if (form == null) continue;
                    forms.add(form);
                }
            }
            ArrayList<Form> arrayList = forms;
            return arrayList;
        }
        catch (RepositoryException e) {
            this.getLogger().error("Error getting forms for a content.", (Throwable)e);
            throw new FormsException("Error getting forms for a content.", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public List<Node> getFormContentNodes(String siteName, String language) throws FormsException {
        ArrayList<Node> contentNodes = new ArrayList<Node>();
        Session session = null;
        try {
            session = this._repository.login();
            String xpathQuery = "//element(*, ametys:content)[@ametys:site = '" + siteName + "' and @ametys-internal:language = '" + language + "']/ametys-internal:forms";
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(xpathQuery, "xpath");
            NodeIterator nodeIterator = query.execute().getNodes();
            while (nodeIterator.hasNext()) {
                Node formNode = nodeIterator.nextNode();
                contentNodes.add(formNode.getParent());
            }
            ArrayList<Node> arrayList = contentNodes;
            return arrayList;
        }
        catch (RepositoryException e) {
            throw new FormsException("Error executing the query to find the forms of the site '" + siteName + "' and of language '" + language + "'.", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public Content getFormContent(String formId) throws FormsException {
        Session session = null;
        try {
            session = this._repository.login();
            String xpathQuery = "//element(*, ametys:content)/ametys-internal:forms/*[@ametys:id = '" + formId + "']";
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(xpathQuery, "xpath");
            NodeIterator nodeIterator = query.execute().getNodes();
            if (nodeIterator.hasNext()) {
                Content content;
                Node node = nodeIterator.nextNode().getParent().getParent();
                Content content2 = content = (Content)this._resolver.resolve(node, false);
                return content2;
            }
            Content content = null;
            return content;
        }
        catch (RepositoryException e) {
            throw new FormsException("Error executing the query to find the content containing the form of id " + formId, e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public List<Form> getForms(Node node) throws FormsException, RepositoryException {
        ArrayList<Form> forms = new ArrayList<Form>();
        try {
            Node formsNode;
            if (node.hasNode(FORMS_NODE) && (formsNode = node.getNode(FORMS_NODE)) != null) {
                NodeIterator formsNodeIterator = formsNode.getNodes();
                while (formsNodeIterator.hasNext()) {
                    Node formNode = formsNodeIterator.nextNode();
                    Form form = this._extractForm(formNode);
                    if (form == null) continue;
                    forms.add(form);
                }
            }
            return forms;
        }
        catch (RepositoryException e) {
            throw new FormsException("Error executing the query to find the forms of the node '" + node.getName() + "' (" + node.getIdentifier() + ").", e);
        }
    }

    public void createForm(String siteName, Form form, Content content) throws FormsException {
        try {
            if (content instanceof JCRAmetysObject) {
                Node contentNode = ((JCRAmetysObject)content).getNode();
                Node formsNode = this._createOrGetFormsNode(contentNode);
                Node formNode = this._storeForm(formsNode, form);
                this._fillFormNode(formNode, form);
                for (Field field : form.getFields()) {
                    Node fieldNode = this._storeField(formNode, field);
                    this._fillFieldNode(fieldNode, field);
                }
                contentNode.getSession().save();
            }
        }
        catch (RepositoryException e) {
            throw new FormsException("Repository exception while storing the form properties.", e);
        }
    }

    public void updateForm(String siteName, Form form, Content content) throws FormsException {
        Session session = null;
        try {
            session = this._repository.login();
            String id = form.getId();
            if (content instanceof JCRAmetysObject) {
                String xpathQuery = "//element(*, ametys:content)/ametys-internal:forms/*[@ametys:id = '" + id + "']";
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(xpathQuery, "xpath");
                NodeIterator nodeIterator = query.execute().getNodes();
                if (nodeIterator.hasNext()) {
                    Node formNode = nodeIterator.nextNode();
                    this._fillFormNode(formNode, form);
                    this._updateFields(form, formNode);
                    if (session.hasPendingChanges()) {
                        session.save();
                    }
                }
            }
        }
        catch (RepositoryException e) {
            throw new FormsException("Repository exception while storing the form properties.", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public String getDisplayValue(Field field, String value) {
        Map<String, String> properties = field.getProperties();
        for (String key : properties.keySet()) {
            String index;
            Matcher matcher = OPTION_VALUE_PATTERN.matcher(key);
            if (!matcher.matches() || !StringUtils.trim((String)value).equals(StringUtils.trim((String)properties.get(key))) || !properties.containsKey("option-" + (index = matcher.group(1)) + "-label")) continue;
            return properties.get("option-" + index + "-label");
        }
        return value;
    }

    protected Form _extractForm(Node formNode) throws RepositoryException {
        Form form = null;
        String id = this._getSingleProperty(formNode, "ametys:id", "");
        if (!StringUtils.isEmpty((String)id)) {
            String label = this._getSingleProperty(formNode, "ametys:label", "");
            String receiptFieldId = this._getSingleProperty(formNode, FORM_PROPERTY_RECEIPT_FIELD_ID, "");
            String receiptFieldBody = this._getSingleProperty(formNode, FORM_PROPERTY_RECEIPT_BODY, "");
            String receiptFieldSubject = this._getSingleProperty(formNode, FORM_PROPERTY_RECEIPT_SUBJECT, "");
            String receiptFieldFromAddress = this._getSingleProperty(formNode, FORM_PROPERTY_RECEIPT_FROM_ADDRESS, "");
            String redirectTo = this._getSingleProperty(formNode, FORM_PROPERTY_REDIRECT_TO, "");
            Collection<String> emails = this._getMultipleProperty(formNode, FORM_PROPERTY_EMAILS);
            String workflowName = this._getSingleProperty(formNode, FORM_PROPERTY_WORKFLOW_NAME, "");
            String limit = this._getSingleProperty(formNode, FORM_PROPERTY_LIMIT, "");
            String remainingPlaces = this._getSingleProperty(formNode, FORM_PROPERTY_REMAINING_PLACES, "");
            String noRemainingPlaces = this._getSingleProperty(formNode, FORM_PROPERTY_NO_REMAINING_PLACES, "");
            form = new Form();
            Content content = (Content)this._resolver.resolve(formNode.getParent().getParent(), false);
            form.setContentId(content.getId());
            form.setId(id);
            form.setLabel(label);
            form.setReceiptFieldId(receiptFieldId);
            form.setReceiptFieldBody(receiptFieldBody);
            form.setReceiptFieldSubject(receiptFieldSubject);
            form.setReceiptFieldFromAddress(receiptFieldFromAddress);
            form.setNotificationEmails(new HashSet<String>(emails));
            form.setRedirectTo(redirectTo);
            form.setWorkflowName(workflowName);
            form.setLimit(limit);
            form.setRemainingPlaces(remainingPlaces);
            form.setNoRemainingPlaces(noRemainingPlaces);
            this._extractFields(formNode, form);
        }
        return form;
    }

    protected void _extractFields(Node formNode, Form form) throws RepositoryException {
        NodeIterator nodes = formNode.getNodes();
        while (nodes.hasNext()) {
            Node node = nodes.nextNode();
            Field field = this._extractField(node);
            form.getFields().add(field);
        }
    }

    protected Field _extractField(Node fieldNode) throws RepositoryException {
        Field field = null;
        String id = this._getSingleProperty(fieldNode, "ametys:id", "");
        String type = this._getSingleProperty(fieldNode, FIELD_PROPERTY_TYPE, "");
        Field.FieldType fieldType = Field.FieldType.valueOf(type);
        if (!StringUtils.isEmpty((String)id) && !StringUtils.isEmpty((String)type)) {
            String name = this._getSingleProperty(fieldNode, FIELD_PROPERTY_NAME, "");
            String label = this._getSingleProperty(fieldNode, "ametys:label", "");
            Map<String, String> properties = this._getFieldProperties(fieldNode);
            field = new Field(fieldType);
            field.setId(id);
            field.setName(name);
            field.setLabel(label);
            field.setProperties(properties);
        }
        return field;
    }

    protected Node _storeForm(Node contentNode, Form form) throws RepositoryException {
        String name = form.getId();
        if (StringUtils.isBlank((String)name)) {
            name = "form";
        }
        String nodeName = NameHelper.filterName((String)name);
        String notExistingNodeName = this._getNotExistingNodeName(contentNode, nodeName);
        Node formNode = contentNode.addNode(notExistingNodeName);
        formNode.addMixin("mix:referenceable");
        return formNode;
    }

    protected void _fillFormNode(Node formNode, Form form) throws RepositoryException, FormsException {
        Set<String> emails = form.getNotificationEmails();
        String[] emailArray = emails.toArray(new String[emails.size()]);
        formNode.setProperty("ametys:id", form.getId());
        formNode.setProperty("ametys:label", form.getLabel());
        formNode.setProperty(FORM_PROPERTY_RECEIPT_FIELD_ID, form.getReceiptFieldId());
        formNode.setProperty(FORM_PROPERTY_RECEIPT_BODY, form.getReceiptFieldBody());
        formNode.setProperty(FORM_PROPERTY_RECEIPT_SUBJECT, form.getReceiptFieldSubject());
        formNode.setProperty(FORM_PROPERTY_RECEIPT_FROM_ADDRESS, form.getReceiptFieldFromAddress());
        formNode.setProperty(FORM_PROPERTY_EMAILS, emailArray);
        formNode.setProperty(FORM_PROPERTY_REDIRECT_TO, form.getRedirectTo());
        formNode.setProperty(FORM_PROPERTY_WORKFLOW_NAME, form.getWorkflowName());
        formNode.setProperty(FORM_PROPERTY_REMAINING_PLACES, form.getRemainingPlaces());
        formNode.setProperty(FORM_PROPERTY_LIMIT, form.getLimit());
        formNode.setProperty(FORM_PROPERTY_NO_REMAINING_PLACES, form.getNoRemainingPlaces());
    }

    protected Node _storeField(Node formNode, Field field) throws RepositoryException, FormsException {
        String name = field.getId();
        if (StringUtils.isBlank((String)name)) {
            name = "field";
        }
        String nodeName = NameHelper.filterName((String)name);
        String notExistingNodeName = this._getNotExistingNodeName(formNode, nodeName);
        Node fieldNode = formNode.addNode(notExistingNodeName);
        fieldNode.addMixin("mix:referenceable");
        return fieldNode;
    }

    protected void _fillFieldNode(Node fieldNode, Field field) throws RepositoryException, FormsException {
        fieldNode.setProperty("ametys:id", field.getId());
        fieldNode.setProperty(FIELD_PROPERTY_TYPE, field.getType().toString());
        fieldNode.setProperty(FIELD_PROPERTY_NAME, field.getName());
        fieldNode.setProperty("ametys:label", field.getLabel());
        Map<String, String> fieldProperties = field.getProperties();
        for (String propertyName : fieldProperties.keySet()) {
            String value = fieldProperties.get(propertyName);
            if (value == null) continue;
            String name = FIELD_PROPERTY_PREFIX + propertyName;
            fieldNode.setProperty(name, value);
        }
    }

    protected void _updateFields(Form form, Node formNode) throws RepositoryException, FormsException {
        Map<String, Field> fieldMap = form.getFieldMap();
        NodeIterator fieldNodes = formNode.getNodes();
        while (fieldNodes.hasNext()) {
            Node fieldNode = fieldNodes.nextNode();
            if (!fieldNode.hasProperty("ametys:id")) continue;
            String fieldId = fieldNode.getProperty("ametys:id").getString();
            if (fieldMap.containsKey(fieldId)) {
                Field field = fieldMap.get(fieldId);
                this._fillFieldNode(fieldNode, field);
                fieldMap.remove(fieldId);
                continue;
            }
            fieldNode.remove();
        }
        for (Map.Entry<String, Field> entry : fieldMap.entrySet()) {
            Field newField = entry.getValue();
            Node fieldNode = this._storeField(formNode, newField);
            this._fillFieldNode(fieldNode, newField);
        }
    }

    protected String _getNotExistingNodeName(Node container, String baseName) throws RepositoryException {
        Object name = baseName;
        int index = 2;
        while (container.hasNode((String)name)) {
            name = baseName + index;
            ++index;
        }
        return name;
    }

    protected String _getSingleProperty(Node node, String propertyName, String defaultValue) throws RepositoryException {
        String value = defaultValue;
        if (node.hasProperty(propertyName)) {
            value = node.getProperty(propertyName).getString();
        }
        return value;
    }

    protected Collection<String> _getMultipleProperty(Node node, String propertyName) throws RepositoryException {
        ArrayList<String> values = new ArrayList<String>();
        if (node.hasProperty(propertyName)) {
            Value[] propertyValues;
            for (Value value : propertyValues = node.getProperty(propertyName).getValues()) {
                values.add(value.getString());
            }
        }
        return values;
    }

    protected Map<String, String> _getFieldProperties(Node node) throws RepositoryException {
        HashMap<String, String> values = new HashMap<String, String>();
        PropertyIterator propertyIt = node.getProperties("ametys:property-*");
        while (propertyIt.hasNext()) {
            Property property = propertyIt.nextProperty();
            String propName = property.getName();
            String name = propName.substring(FIELD_PROPERTY_PREFIX.length(), propName.length());
            String value = property.getString();
            values.put(name, value);
        }
        return values;
    }

    public void remove(Form form, Content content) throws FormsException {
        Session session = null;
        try {
            session = this._repository.login();
            String id = form.getId();
            String xpathQuery = "//element(*, ametys:content)[@jcr:uuid = '" + ((JCRAmetysObject)content).getNode().getIdentifier() + "']/ametys-internal:forms/*[@ametys:id = '" + id + "']";
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(xpathQuery, "xpath");
            NodeIterator nodeIterator = query.execute().getNodes();
            if (nodeIterator.hasNext()) {
                Node formNode = nodeIterator.nextNode();
                formNode.remove();
                if (session.hasPendingChanges()) {
                    session.save();
                }
            }
        }
        catch (RepositoryException e) {
            throw new FormsException("Repository exception while storing the form properties.", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected Node _createOrGetFormsNode(Node baseNode) throws RepositoryException {
        Node node = null;
        node = baseNode.hasNode(FORMS_NODE) ? baseNode.getNode(FORMS_NODE) : baseNode.addNode(FORMS_NODE, "nt:unstructured");
        return node;
    }
}

