/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.generators;

import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.Step;
import org.ametys.core.right.RightManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.forms.generators.FormAdminEntryInformationGenerator;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;

public class FormEntryPropertiesGenerator
extends FormAdminEntryInformationGenerator {
    protected WorkflowProvider _workflowProvider;
    protected I18nUtils _i18nUtils;
    protected RightManager _rightManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._workflowProvider = (WorkflowProvider)smanager.lookup(WorkflowProvider.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
    }

    @Override
    protected void _addAdditionalEntryAttributes(FormEntry entry, AttributesImpl attrs) {
        super._addAdditionalEntryAttributes(entry, attrs);
        try {
            attrs.addCDATAAttribute("access", Boolean.toString(this._rightManager.currentUserHasRight("REPOSITORY_Rights_Access", (Object)"/repository") == RightManager.RightResult.RIGHT_ALLOW));
            attrs.addCDATAAttribute("uuid", entry.getNode().getIdentifier());
            attrs.addCDATAAttribute("path", entry.getNode().getPath());
        }
        catch (Exception e) {
            this.getLogger().error("Can get uuid from answer with id '" + entry.getId() + "'", (Throwable)e);
        }
        if (entry.getForm().hasWorkflow()) {
            Step currentStep;
            WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)entry);
            WorkflowDescriptor workflowDescriptor = workflow.getWorkflowDescriptor(entry.getForm().getWorkflowName());
            StepDescriptor stepDescriptor = workflowDescriptor.getStep((currentStep = (Step)workflow.getCurrentSteps(entry.getWorkflowId()).iterator().next()).getStepId());
            I18nizableText workflowStepName = new I18nizableText("application", stepDescriptor.getName());
            if ("application".equals(workflowStepName.getCatalogue())) {
                attrs.addCDATAAttribute("icon", "/plugins/cms/resources_workflow/" + workflowStepName.getKey() + "-small.png");
            } else {
                String pluginName = workflowStepName.getCatalogue().substring("plugin.".length());
                attrs.addCDATAAttribute("icon", "/plugins/" + pluginName + "/resources/img/workflow/" + workflowStepName.getKey() + "-small.png");
            }
            attrs.addCDATAAttribute("workflow", this._i18nUtils.translate((I18nizable)workflowStepName));
        }
    }
}

