/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.sources.ChoiceSourceType;
import org.ametys.plugins.forms.question.types.CheckBoxQuestionType;
import org.ametys.plugins.forms.question.types.ChoicesListQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.forms.repository.type.Rule;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class QuestionRuleHelper
implements Serviceable,
Component {
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    @Callable(rights={"Plugins_Forms_Right_Handle"}, rightContext="right.assignment.context.formsdirectoryaccess", paramIndex=0)
    public Map<String, Object> getSourceQuestions(String formId, String questionId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Form form = (Form)this._resolver.resolveById(formId);
        List questions = form.getQuestions().stream().filter(question -> this._isChoiceListWithNoTooManyOptions((FormQuestion)((Object)question)) || question.getType() instanceof CheckBoxQuestionType).filter(question -> !question.isModifiable()).filter(question -> !question.getId().equals(questionId)).collect(Collectors.toList());
        ArrayList sources = new ArrayList();
        for (FormQuestion question2 : questions) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("label", question2.getTitle());
            properties.put("id", question2.getId());
            sources.add(properties);
        }
        results.put("data", sources);
        return results;
    }

    private boolean _isChoiceListWithNoTooManyOptions(FormQuestion question) {
        FormQuestionType type = question.getType();
        if (type instanceof ChoicesListQuestionType) {
            ChoicesListQuestionType cLType = (ChoicesListQuestionType)type;
            ChoiceSourceType sourceType = cLType.getSourceType(question);
            return !sourceType.remoteData();
        }
        return false;
    }

    @Callable(rights={"Plugins_Forms_Right_Handle"}, rightContext="right.assignment.context.formsdirectoryaccess", paramIndex=0)
    public Map<String, Object> getSourceOptions(String questionId) {
        ChoicesListQuestionType type;
        HashMap<String, Object> results = new HashMap<String, Object>();
        FormQuestion formQuestion = (FormQuestion)this._resolver.resolveById(questionId);
        ArrayList<Map<Object, Object>> options = new ArrayList<Map<Object, Object>>();
        FormQuestionType formQuestionType = formQuestion.getType();
        if (formQuestionType instanceof ChoicesListQuestionType && !(type = (ChoicesListQuestionType)formQuestionType).getSourceType(formQuestion).remoteData()) {
            Map<String, I18nizableText> choices = type.getOptions(formQuestion);
            for (String optionValue : choices.keySet()) {
                HashMap<String, Object> choicesToJson = new HashMap<String, Object>();
                choicesToJson.put("label", choices.get(optionValue));
                choicesToJson.put("value", optionValue);
                options.add(choicesToJson);
            }
            if (type.hasOtherOption(formQuestion)) {
                HashMap<String, Object> choicesToJson = new HashMap<String, Object>();
                choicesToJson.put("label", new I18nizableText("plugin.forms", "PLUGINS_FORMS_DISPLAY_OTHER_OPTION_COMBOBOX"));
                choicesToJson.put("value", "__internal_other");
                options.add(choicesToJson);
            }
        } else {
            options.add(Map.of("label", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTION_RULES_OPTION_CHECKED"), "value", "true"));
            options.add(Map.of("label", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTION_RULES_OPTION_UNCHECKED"), "value", "false"));
        }
        results.put("data", options);
        return results;
    }

    @Callable
    public Map<String, Object> getRuleActions() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ArrayList<Map<String, String>> actions = new ArrayList<Map<String, String>>();
        actions.add(Map.of("label", Rule.QuestionRuleType.HIDE.getLabel(), "value", Rule.QuestionRuleType.HIDE.name()));
        actions.add(Map.of("label", Rule.QuestionRuleType.SHOW.getLabel(), "value", Rule.QuestionRuleType.SHOW.name()));
        results.put("data", actions);
        return results;
    }
}

