/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.menu;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.ClientSideElementHelper;
import org.ametys.core.ui.SimpleMenu;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.util.I18nizableTextKeyComparator;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.FormQuestionTypeExtensionPoint;
import org.ametys.plugins.forms.question.types.RichTextQuestionType;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class FormQuestionButtonMenu
extends SimpleMenu {
    protected FormQuestionTypeExtensionPoint _formQuestionTypeExtensionPoint;
    protected AmetysObjectResolver _resolver;
    protected ObservationManager _observationManager;
    private boolean _galleryInitialized;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._observationManager = (ObservationManager)serviceManager.lookup(ObservationManager.ROLE);
        this._formQuestionTypeExtensionPoint = (FormQuestionTypeExtensionPoint)((Object)serviceManager.lookup(FormQuestionTypeExtensionPoint.ROLE));
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        try {
            this._lazyInitializeContentViewGallery();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to lookup client side element local components", e);
        }
        ArrayList<ClientSideElement.Script> scripts = new ArrayList<ClientSideElement.Script>();
        for (ClientSideElement.Script script : super.getScripts(ignoreRights, contextParameters)) {
            ClientSideElement.Script cloneScript = ClientSideElementHelper.cloneScript((ClientSideElement.Script)script);
            cloneScript.getScriptFiles().add(new ClientSideElement.ScriptFile("/plugins/forms/resources/js/Ametys/plugins/forms/controllers/FormController.js"));
            scripts.add(cloneScript);
        }
        return scripts;
    }

    private synchronized void _lazyInitializeContentViewGallery() throws ConfigurationException {
        if (!this._galleryInitialized) {
            Map<I18nizableText, Set<FormQuestionType>> typesByGroup = this._getQuestionTypeByGroup();
            if (typesByGroup.size() > 0) {
                SimpleMenu.GalleryItem galleryItem = new SimpleMenu.GalleryItem((SimpleMenu)this);
                for (I18nizableText groupLabel : typesByGroup.keySet()) {
                    SimpleMenu.GalleryGroup galleryGroup = new SimpleMenu.GalleryGroup((SimpleMenu)this, groupLabel);
                    galleryItem.addGroup(galleryGroup);
                    Set<FormQuestionType> cTypes = typesByGroup.get(groupLabel);
                    for (FormQuestionType questionType : cTypes) {
                        String id = this.getId() + "-" + questionType.getId();
                        Configuration conf = this._getQuestionTypeItemConfiguration(id, questionType);
                        this._getGalleryItemManager().addComponent(this._pluginName, null, id, StaticClientSideElement.class, conf);
                        galleryGroup.addItem(new SimpleMenu.UnresolvedItem((SimpleMenu)this, id, true));
                    }
                }
                this._galleryItems.add(galleryItem);
            }
            if (this._galleryItems.size() > 0) {
                try {
                    this._getGalleryItemManager().initialize();
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to lookup parameter local components", (Throwable)e);
                }
            }
        }
        this._galleryInitialized = true;
    }

    protected Configuration _getQuestionTypeItemConfiguration(String itemId, FormQuestionType questionType) {
        DefaultConfiguration conf = new DefaultConfiguration("extension");
        conf.setAttribute("id", itemId);
        DefaultConfiguration classConf = new DefaultConfiguration("class");
        classConf.setAttribute("name", "Ametys.plugins.forms.controllers.FormController");
        DefaultConfiguration labelConf = new DefaultConfiguration("label");
        I18nizableText label = questionType.getLabel();
        labelConf.setAttribute("i18n", "true");
        labelConf.setValue(label.getCatalogue() + ":" + label.getKey());
        classConf.addChild((Configuration)labelConf);
        DefaultConfiguration descConf = new DefaultConfiguration("description");
        I18nizableText desc = questionType.getDescription();
        descConf.setAttribute("i18n", "true");
        descConf.setValue(desc.getCatalogue() + ":" + desc.getKey());
        classConf.addChild((Configuration)descConf);
        DefaultConfiguration iconGlyphConf = new DefaultConfiguration("icon-glyph");
        iconGlyphConf.setValue(questionType.getIconGlyph());
        classConf.addChild((Configuration)iconGlyphConf);
        Map commonConfig = (Map)this._script.getParameters().get("items-config");
        for (String tagName : commonConfig.keySet()) {
            DefaultConfiguration c = new DefaultConfiguration(tagName);
            Object value = commonConfig.get(tagName);
            if (value instanceof I18nizableText) {
                I18nizableText i18nText = (I18nizableText)value;
                c.setAttribute("i18n", String.valueOf(i18nText.isI18n()));
                c.setValue(i18nText.isI18n() ? i18nText.getKey() : i18nText.getLabel());
            } else {
                c.setValue(String.valueOf(commonConfig.get(tagName)));
            }
            classConf.addChild((Configuration)c);
        }
        if (!(questionType instanceof RichTextQuestionType)) {
            DefaultConfiguration noEntryOnlyConf = new DefaultConfiguration("enable-on-noentry-only");
            noEntryOnlyConf.setValue("true");
            classConf.addChild((Configuration)noEntryOnlyConf);
        }
        DefaultConfiguration typeIdConf = new DefaultConfiguration("type-id");
        typeIdConf.setValue(questionType.getId());
        classConf.addChild((Configuration)typeIdConf);
        conf.addChild((Configuration)classConf);
        return conf;
    }

    protected Map<I18nizableText, Set<FormQuestionType>> _getQuestionTypeByGroup() {
        TreeMap<I18nizableText, Set<FormQuestionType>> groups = new TreeMap<I18nizableText, Set<FormQuestionType>>((Comparator<I18nizableText>)new I18nizableTextKeyComparator());
        Set questionTypesIds = this._formQuestionTypeExtensionPoint.getExtensionsIds();
        for (String questionTypeId : questionTypesIds) {
            FormQuestionType questionType = (FormQuestionType)this._formQuestionTypeExtensionPoint.getExtension(questionTypeId);
            this._script.getScriptFiles().addAll(questionType.getScripts());
            this.addType(questionType, groups);
        }
        return groups;
    }

    protected void addType(FormQuestionType type, Map<I18nizableText, Set<FormQuestionType>> groups) {
        I18nizableText group = type.getCategory();
        if (group.isI18n() && group.getKey().isEmpty() || !group.isI18n() && group.getLabel().isEmpty()) {
            group = new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTION_TYPE_CATEGORY_90_OTHERS");
        }
        if (!groups.containsKey(group)) {
            groups.put(group, new TreeSet<FormQuestionType>(new QuestionTypeComparator()));
        }
        Set<FormQuestionType> types = groups.get(group);
        types.add(type);
    }

    class QuestionTypeComparator
    implements Comparator<FormQuestionType> {
        QuestionTypeComparator() {
        }

        @Override
        public int compare(FormQuestionType type1, FormQuestionType type2) {
            Integer order2;
            Integer order1 = type1.getDisplayOrder();
            int compareTo = order1.compareTo(order2 = type2.getDisplayOrder());
            if (compareTo == 0) {
                I18nizableText t1 = type1.getLabel();
                I18nizableText t2 = type2.getLabel();
                String str1 = t1.isI18n() ? t1.getKey() : t1.getLabel();
                String str2 = t2.isI18n() ? t2.getKey() : t2.getLabel();
                compareTo = str1.toString().compareTo(str2.toString());
                if (compareTo == 0) {
                    return 1;
                }
            }
            return compareTo;
        }
    }
}

