/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.computing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.question.computing.AbstractStaticComputingType;
import org.ametys.plugins.forms.question.sources.ChoiceOption;
import org.ametys.plugins.forms.question.sources.ChoiceOptionWithCost;
import org.ametys.plugins.forms.question.sources.ChoiceSourceType;
import org.ametys.plugins.forms.question.sources.ManualWithCostsSourceType;
import org.ametys.plugins.forms.question.types.ChoicesListQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;

public class CostComputingType
extends AbstractStaticComputingType {
    public static final String ATTRIBUTE_CURRENCY = "currency";
    public static final String EURO_CURRENCY_VALUE = "euro";
    public static final String POUND_CURRENCY_VALUE = "pound";
    public static final String DOLLAR_CURRENCY_VALUE = "dollar";
    protected Map<String, ModelItem> _costComputingItems;

    @Override
    public Map<String, ModelItem> getModelItems() {
        this._costComputingItems = new HashMap<String, ModelItem>();
        ElementDefinition currency = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_CURRENCY, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_COMPUTING_COST_CURRENCY", "PLUGINS_FORMS_QUESTIONS_DIALOG_COMPUTING_COST_CURRENCY_DESC", null);
        StaticEnumerator currencyStaticEnumerator = new StaticEnumerator();
        currencyStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_COMPUTING_COST_CURRENCY_EURO"), (Object)EURO_CURRENCY_VALUE);
        currencyStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_COMPUTING_COST_CURRENCY_POUND"), (Object)POUND_CURRENCY_VALUE);
        currencyStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_COMPUTING_COST_CURRENCY_DOLLAR"), (Object)DOLLAR_CURRENCY_VALUE);
        currency.setEnumerator((Enumerator)currencyStaticEnumerator);
        currency.setDefaultValue((Object)EURO_CURRENCY_VALUE);
        this._costComputingItems.put(currency.getName(), (ModelItem)currency);
        return this._costComputingItems;
    }

    @Override
    public List<ViewItem> getViewElements() {
        ArrayList<ViewItem> viewElements = new ArrayList<ViewItem>();
        ViewElement grid = new ViewElement();
        grid.setDefinition((ElementDefinition)this._costComputingItems.get(ATTRIBUTE_CURRENCY));
        viewElements.add((ViewItem)grid);
        return viewElements;
    }

    @Override
    public Object getComputedValue(FormQuestion computedQuestion, FormEntry entry) {
        Form form = entry.getForm();
        Double cost = 0.0;
        for (FormQuestion question : form.getQuestions()) {
            if (!(question.getType() instanceof ChoicesListQuestionType)) continue;
            String nameForForm = question.getNameForForm();
            ChoiceSourceType sourceType = (ChoiceSourceType)this._choiceSourceTypeExtensionPoint.getExtension((String)question.getValue("source-type"));
            if (!(sourceType instanceof ManualWithCostsSourceType) || !entry.hasValue(nameForForm)) continue;
            List<Object> values = new ArrayList();
            values = entry.isMultiple(nameForForm) ? List.of((String[])entry.getValue(nameForForm)) : Collections.singletonList((String)entry.getValue(nameForForm));
            try {
                HashMap<String, Object> enumParam = new HashMap<String, Object>();
                enumParam.put("question", (Object)question);
                Set options = sourceType.getTypedEntries(enumParam).keySet();
                for (ChoiceOption option : options) {
                    if (!values.contains(option.getValue())) continue;
                    cost = cost + ((ChoiceOptionWithCost)option).getCost();
                }
            }
            catch (Exception e) {
                this.getLogger().error("An error occured while getting choices options", (Throwable)e);
            }
        }
        return cost;
    }

    @Override
    public String getStorageType(FormQuestion question) {
        return "double";
    }

    @Override
    public boolean canEdit() {
        return true;
    }
}

