/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.types;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;

public interface AutocompleteAwareQuestionType {
    public static final String ATTRIBUTE_AUTOCOMPLETE = "autocomplete";

    private Map<AutocompleteOption, List<InputType>> _getAutocompleteOptions() {
        HashMap<AutocompleteOption, List<InputType>> autocompleteOptions = new HashMap<AutocompleteOption, List<InputType>>();
        autocompleteOptions.put(new AutocompleteOption("name", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_FULLNAME")), List.of(InputType.TEXT));
        autocompleteOptions.put(new AutocompleteOption("honorific-prefix", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_HONORIFIC_PREFIX")), List.of(InputType.SELECT));
        autocompleteOptions.put(new AutocompleteOption("given-name", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_GIVEN_NAME")), List.of(InputType.TEXT));
        autocompleteOptions.put(new AutocompleteOption("family-name", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_FAMILY_NAME")), List.of(InputType.TEXT));
        autocompleteOptions.put(new AutocompleteOption("email", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_EMAIL")), List.of(InputType.TEXT));
        autocompleteOptions.put(new AutocompleteOption("organization-title", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_ORGANIZATION_TITLE")), List.of(InputType.TEXT));
        autocompleteOptions.put(new AutocompleteOption("organization", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_ORGANIZATION")), List.of(InputType.TEXT));
        autocompleteOptions.put(new AutocompleteOption("street-address", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_STREET_ADDRESS")), List.of(InputType.TEXT, InputType.TEXTAREA));
        autocompleteOptions.put(new AutocompleteOption("country-name", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_COUNTRY_NAME")), List.of(InputType.TEXT, InputType.SELECT));
        autocompleteOptions.put(new AutocompleteOption("postal-code", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_POSTAL_CODE")), List.of(InputType.TEXT));
        autocompleteOptions.put(new AutocompleteOption("bday", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_BIRTHDAY")), List.of(InputType.DATE));
        autocompleteOptions.put(new AutocompleteOption("sex", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_SEX")), List.of(InputType.SELECT));
        autocompleteOptions.put(new AutocompleteOption("tel", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_TEL")), List.of(InputType.TEXT));
        autocompleteOptions.put(new AutocompleteOption("url", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_URL")), List.of(InputType.TEXT));
        return autocompleteOptions;
    }

    default public ModelItem getAutocompleteModelItem(InputType inputType) {
        ElementDefinition autocomplete = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_AUTOCOMPLETE, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_LABEL", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_DESC", null);
        StaticEnumerator autocompleteStaticEnumerator = new StaticEnumerator();
        this._getAutocompleteOptions().entrySet().stream().filter(e -> ((List)e.getValue()).contains((Object)inputType)).forEach(e -> autocompleteStaticEnumerator.add(((AutocompleteOption)e.getKey()).label(), (Object)((AutocompleteOption)e.getKey()).value()));
        autocomplete.setEnumerator((Enumerator)autocompleteStaticEnumerator);
        return autocomplete;
    }

    default public ViewElement getAutocompleteViewElement(Model model) {
        ViewElement description = new ViewElement();
        description.setDefinition((ElementDefinition)model.getModelItem(ATTRIBUTE_AUTOCOMPLETE));
        return description;
    }

    default public String getAutocomplete(FormQuestion question) {
        return (String)question.getValue(ATTRIBUTE_AUTOCOMPLETE);
    }

    public record AutocompleteOption(String value, I18nizableText label) {
    }

    public static enum InputType {
        TEXT,
        TEXTAREA,
        DATE,
        SELECT;

    }
}

