/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.types;

import java.util.List;
import java.util.Map;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.question.types.AbstractFormQuestionType;
import org.ametys.plugins.forms.question.types.MultipleAwareFormQuestionType;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.forms.repository.type.Matrix;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MatrixQuestionType
extends AbstractFormQuestionType
implements MultipleAwareFormQuestionType {
    public static final String ATTRIBUTE_GRID = "matrix-grid";
    public static final String DEFAULT_TITLE = "PLUGIN_FORMS_QUESTION_DEFAULT_TITLE_MATRIX";
    protected JSONUtils _jsonUtils;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    @Override
    protected List<ModelItem> _getModelItems() {
        List<ModelItem> modelItems = super._getModelItems();
        ElementDefinition matrixWidget = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_GRID, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_MATRIX_GRID", "PLUGINS_FORMS_QUESTIONS_DIALOG_MATRIX_GRID_DESC", null);
        matrixWidget.setWidget("edition.matrix-grid");
        modelItems.add((ModelItem)matrixWidget);
        modelItems.add(this.getMultipleModelItem());
        return modelItems;
    }

    @Override
    protected SimpleViewItemGroup _getMainTab() {
        SimpleViewItemGroup mainFieldset = super._getMainTab();
        ViewElement widgetMatrix = new ViewElement();
        widgetMatrix.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_GRID));
        mainFieldset.addViewItem((ViewItem)widgetMatrix);
        return mainFieldset;
    }

    @Override
    protected SimpleViewItemGroup _getAdvancedTab() {
        SimpleViewItemGroup advancedFieldset = super._getAdvancedTab();
        advancedFieldset.addViewItem((ViewItem)this.getMultipleViewElement(this.getModel()));
        return advancedFieldset;
    }

    @Override
    public void saxAdditionalInfos(ContentHandler contentHandler, FormQuestion question) throws SAXException {
        super.saxAdditionalInfos(contentHandler, question);
        Map<String, String> rows = this.getRows(question);
        if (rows != null) {
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"options");
            for (String key : rows.keySet()) {
                AttributesImpl attr = new AttributesImpl();
                attr.addCDATAAttribute("value", key);
                XMLUtils.createElement((ContentHandler)contentHandler, (String)"option", (Attributes)attr, (String)rows.get(key));
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"options");
            Map<String, String> columns = this.getColumns(question);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"columns");
            for (String key : columns.keySet()) {
                AttributesImpl attr = new AttributesImpl();
                attr.addCDATAAttribute("value", key);
                XMLUtils.createElement((ContentHandler)contentHandler, (String)"column", (Attributes)attr, (String)columns.get(key));
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"columns");
        }
    }

    public Map<String, String> getColumns(FormQuestion question) {
        Map values = this._jsonUtils.convertJsonToMap((String)question.getValue(ATTRIBUTE_GRID));
        return (Map)values.get("columns");
    }

    public Map<String, String> getRows(FormQuestion question) {
        Map values = this._jsonUtils.convertJsonToMap((String)question.getValue(ATTRIBUTE_GRID));
        return (Map)values.get("options");
    }

    @Override
    public String getStorageType(FormQuestion question) {
        return "matrix";
    }

    @Override
    public I18nizableText getDefaultTitle() {
        return new I18nizableText("plugin.forms", DEFAULT_TITLE);
    }

    @Override
    public boolean isQuestionConfigured(FormQuestion question) {
        Map<String, String> rows = this.getRows(question);
        Map<String, String> columns = this.getColumns(question);
        return rows != null && !rows.isEmpty() && columns != null && !columns.isEmpty();
    }

    @Override
    public void saxEntryValue(ContentHandler contentHandler, FormQuestion question, FormEntry entry) throws SAXException {
        Map<String, String> columns;
        super.saxEntryValue(contentHandler, question, entry);
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"additional-infos");
        Matrix matrix = (Matrix)entry.getValue(question.getNameForForm());
        if (matrix != null && (columns = this.getColumns(question)) != null) {
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"columns");
            for (String colValue : columns.keySet()) {
                AttributesImpl attr = new AttributesImpl();
                attr.addCDATAAttribute("value", colValue);
                XMLUtils.createElement((ContentHandler)contentHandler, (String)"column", (Attributes)attr, (String)columns.get(colValue));
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"columns");
            Map<String, String> rows = this.getRows(question);
            if (rows != null) {
                XMLUtils.startElement((ContentHandler)contentHandler, (String)"options");
                for (String rowValue : rows.keySet()) {
                    List opts = (List)matrix.get(rowValue);
                    AttributesImpl attr = new AttributesImpl();
                    attr.addCDATAAttribute("label", rows.get(rowValue));
                    attr.addCDATAAttribute("value", rowValue);
                    XMLUtils.startElement((ContentHandler)contentHandler, (String)"option", (Attributes)attr);
                    for (String opt : columns.keySet()) {
                        AttributesImpl attrValue = new AttributesImpl();
                        attrValue.addCDATAAttribute("value", rowValue);
                        boolean isChecked = opts != null && opts.contains(opt);
                        attrValue.addCDATAAttribute("checked", String.valueOf(isChecked));
                        XMLUtils.createElement((ContentHandler)contentHandler, (String)"value", (Attributes)attrValue);
                    }
                    XMLUtils.endElement((ContentHandler)contentHandler, (String)"option");
                }
                XMLUtils.endElement((ContentHandler)contentHandler, (String)"options");
            }
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"additional-infos");
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished(FormQuestion question) {
        List<String> fieldNames = super.getFieldToDisableIfFormPublished(question);
        fieldNames.add(ATTRIBUTE_GRID);
        fieldNames.add("multiple");
        return fieldNames;
    }

    @Override
    public String getJSRenderer(FormQuestion question) {
        return "Ametys.plugins.forms.helper.SearchEntriesGridHelper.renderMatrix";
    }
}

