/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.types;

import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Validator;
import org.apache.commons.collections.ListUtils;

public interface RestrictiveQuestionType {
    public static final String ATTRIBUTE_READING_CHECKBOX = "readingCheckbox";
    public static final String ATTRIBUTE_WRITING_CHECKBOX = "writingCheckbox";
    public static final String ATTRIBUTE_READING = "reading";
    public static final String ATTRIBUTE_WRITING = "writing";
    public static final Long INITIAL_WORKFLOW_ID = 0L;

    default public List<ModelItem> getRestrictiveModelItems() {
        ElementDefinition readingCheckbox = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_READING_CHECKBOX, "boolean", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_READING_CHECKBOX", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_READING_CHECKBOX_DESC", null);
        ElementDefinition reading = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_READING, "long", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_READING", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_READING_DESC", null);
        reading.setMultiple(true);
        HashMap<String, I18nizableText> readingWidgetParameters = new HashMap<String, I18nizableText>();
        readingWidgetParameters.put("naturalOrder", new I18nizableText("true"));
        reading.setWidgetParameters(readingWidgetParameters);
        HashMap<String, I18nizableText> widgetParameters = new HashMap<String, I18nizableText>();
        widgetParameters.put("emptyText", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_READING_PLACEHOLDER"));
        reading.setWidgetParameters(widgetParameters);
        DisableConditions disableConditions = new DisableConditions();
        DisableCondition condition = new DisableCondition(ATTRIBUTE_READING_CHECKBOX, DisableCondition.OPERATOR.NEQ, "true");
        disableConditions.getConditions().add(condition);
        reading.setDisableConditions(disableConditions);
        ElementDefinition writingCheckbox = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_WRITING_CHECKBOX, "boolean", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_WRITING_CHECKBOX", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_WRITING_CHECKBOX_DESC", null);
        ElementDefinition writing = FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_WRITING, "long", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_WRITING", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_WRITING_DESC", (Validator)new DefaultValidator(null, true));
        writing.setMultiple(true);
        HashMap<String, I18nizableText> writingWidgetParameters = new HashMap<String, I18nizableText>();
        writingWidgetParameters.put("naturalOrder", new I18nizableText("true"));
        writing.setWidgetParameters(writingWidgetParameters);
        DisableConditions writingDisableConditions = new DisableConditions();
        DisableCondition writingCondition = new DisableCondition(ATTRIBUTE_WRITING_CHECKBOX, DisableCondition.OPERATOR.NEQ, "true");
        writingDisableConditions.getConditions().add(writingCondition);
        writing.setDisableConditions(writingDisableConditions);
        return List.of(readingCheckbox, reading, writingCheckbox, writing);
    }

    public WorkflowDescriptor getWorkflowDescriptor(Form var1);

    default public SimpleViewItemGroup getRestrictiveTab(Model model, Form form) {
        SimpleViewItemGroup restrictiveFieldset = new SimpleViewItemGroup();
        restrictiveFieldset.setName("restriction");
        restrictiveFieldset.setLabel(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_FIELDSET"));
        restrictiveFieldset.setDescription(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_RESTRICTIVE_FIELDSET_DESCRIPTION"));
        restrictiveFieldset.setRole("tab");
        ViewElement readingCheckbox = new ViewElement();
        readingCheckbox.setDefinition((ElementDefinition)model.getModelItem(ATTRIBUTE_READING_CHECKBOX));
        restrictiveFieldset.addViewItem((ViewItem)readingCheckbox);
        ViewElement reading = new ViewElement();
        ElementDefinition readingElementDefinition = (ElementDefinition)model.getModelItem(ATTRIBUTE_READING);
        readingElementDefinition.setEnumerator(this._getEnumerator(form, true));
        reading.setDefinition(readingElementDefinition);
        restrictiveFieldset.addViewItem((ViewItem)reading);
        ViewElement writingCheckbox = new ViewElement();
        writingCheckbox.setDefinition((ElementDefinition)model.getModelItem(ATTRIBUTE_WRITING_CHECKBOX));
        restrictiveFieldset.addViewItem((ViewItem)writingCheckbox);
        ViewElement writing = new ViewElement();
        ElementDefinition writingElementDefinition = (ElementDefinition)model.getModelItem(ATTRIBUTE_WRITING);
        writingElementDefinition.setEnumerator(this._getEnumerator(form, false));
        writing.setDefinition(writingElementDefinition);
        restrictiveFieldset.addViewItem((ViewItem)writing);
        return restrictiveFieldset;
    }

    private StaticEnumerator<Long> _getEnumerator(Form form, boolean forReading) {
        StaticEnumerator extensionEnum = new StaticEnumerator();
        WorkflowDescriptor workflowDesc = this.getWorkflowDescriptor(form);
        List steps = workflowDesc.getSteps();
        for (StepDescriptor step : steps) {
            if (!forReading && !this._hasEditAction(step)) continue;
            extensionEnum.add(new I18nizableText("plugin.forms", step.getName()), (Object)step.getId());
        }
        return extensionEnum;
    }

    private boolean _hasEditAction(StepDescriptor step) {
        List actions = step.getActions();
        return actions.stream().map(ActionDescriptor::getMetaAttributes).filter(m -> "edit".equals(m.getOrDefault("action-type", null))).findAny().isPresent();
    }

    default public boolean isReadRestricted(FormQuestion question) {
        return (Boolean)question.getValue(ATTRIBUTE_READING_CHECKBOX, false, false);
    }

    default public boolean isModifiable(FormQuestion question) {
        return (Boolean)question.getValue(ATTRIBUTE_WRITING_CHECKBOX, false, false);
    }

    default public List<Long> getReadingSteps(FormQuestion question) {
        if (question.hasValue(ATTRIBUTE_READING)) {
            return Arrays.asList((Long[])question.getValue(ATTRIBUTE_READING));
        }
        return List.of();
    }

    default public List<Long> getWritingSteps(FormQuestion question) {
        if (question.hasValue(ATTRIBUTE_WRITING)) {
            return ListUtils.sum(Arrays.asList((Object[])question.getValue(ATTRIBUTE_WRITING)), List.of(INITIAL_WORKFLOW_ID));
        }
        return List.of(INITIAL_WORKFLOW_ID);
    }
}

