<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="exsl resolver ametys project">

    <!-- Common for forms -->    
    <xsl:import href="service://pages/services/display/common/form-common.xsl"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">forms mini-survey</xsl:variable>
    
    <!-- Can be : pie, doughnut, or horizontalBar -->
    <xsl:variable name="chart-type">pie</xsl:variable>     
    <xsl:variable name="chart-width">400</xsl:variable>     
    <xsl:variable name="chart-height">400</xsl:variable>     
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="head-scripts"/>
        <xsl:call-template name="mini-survey-js"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:variable name="raw-is-title-visible">
            <xsl:call-template name="common-service-body-nonempty-content-title-content">
                <xsl:with-param name="title" select="form/title/text()"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="is-title-visible" select="string-length($raw-is-title-visible) &gt; 0"/>
       
        
        <xsl:choose>
            <xsl:when test="form/@isMiniSurvey = 'true'">
                <xsl:call-template name="view">
                    <xsl:with-param name="level">
                        <xsl:choose>
                            <xsl:when test="$is-title-visible">2</xsl:when>
                            <xsl:otherwise>1</xsl:otherwise>
                        </xsl:choose>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="hasUniqueChoiceListQuestion" select="count(form//question[@onlyForDisplay = 'false']) = 1 and count(form//question[@type = 'form.ChoicesList']) = 1" />
                <xsl:variable name="isLimitedToOneEntryByUser" select="form/@isLimitedToOneEntryByUser" />
                <div>
                    <xsl:if test="$preview = 'true'">
                        <xsl:attribute name="class">preview</xsl:attribute>
                    </xsl:if>
                    <xsl:call-template name="bo-warnings">
                        <xsl:with-param name="hasUniqueChoiceListQuestion" select="$hasUniqueChoiceListQuestion" />
                        <xsl:with-param name="isLimitedToOneEntryByUser" select="$isLimitedToOneEntryByUser" />
                    </xsl:call-template>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="submit-button-front">
        <xsl:param name="pos" />
        <xsl:param name="formId" />
        
        <xsl:call-template name="common-utils-input-submit">
            <xsl:with-param name="class-name">submit</xsl:with-param>
            <xsl:with-param name="i18nkey">PLUGINS_FORMS_PAGE_FORM_FINISH_BUTTON</xsl:with-param>
            <xsl:with-param name="onclick">try { MiniSurveyHelper.submitForm('<xsl:value-of select="$formId" />', '<xsl:value-of select="$uniqueId" />'); } catch(e) {} return false;</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="submit-button-js-front">
        <xsl:param name="pos" />
        <xsl:param name="formId" />
        
        <xsl:call-template name="common-utils-jswrite-input-submit">
            <xsl:with-param name="class-name">submit</xsl:with-param>
            <xsl:with-param name="i18nkey">PLUGINS_FORMS_PAGE_FORM_FINISH_BUTTON</xsl:with-param>
            <xsl:with-param name="onclick">try { MiniSurveyHelper.submitForm('<xsl:value-of select="$formId" />', '<xsl:value-of select="$uniqueId" />'); } catch(e) {} return false;</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="bo-warnings">
        <xsl:param name="hasUniqueChoiceListQuestion" />
        <xsl:param name="isLimitedToOneEntryByUser" />
    
        <!-- Back-office warnings -->
        <xsl:if test="$rendering-context = 'back'">
            <xsl:variable name="htmlMessage">
                <ul>
                    <xsl:if test="$hasUniqueChoiceListQuestion != 'true'">
                        <li><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_MINI_SURVEY_ERROR_UNIQUE_QUESTION" i18n:catalogue="plugin.forms"/></li>
                    </xsl:if>
                    <xsl:if test="$isLimitedToOneEntryByUser != 'true'">
                        <li><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_MINI_SURVEY_ERROR_ONE_ANSWER" i18n:catalogue="plugin.forms"/></li>
                    </xsl:if>
                </ul>
            </xsl:variable>
                        
            <xsl:call-template name="display-bo-warning-message">
                <xsl:with-param name="titleI18nKey" select="'plugin.web:PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_WARNINGS'"/>
                <xsl:with-param name="htmlMessage" select="$htmlMessage"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="form-additional-attributes">
        <xsl:attribute name="style">display:none</xsl:attribute> 
    </xsl:template>
    
    <xsl:template name="form-additional-info">
        <xsl:call-template name="mini-survey-question-title" />
        <xsl:call-template name="mini-survey-results"/>
        <xsl:call-template name="mini-survey-error"/>
    </xsl:template>
    
    <xsl:template name="mini-survey-question-title">
        <div data-ametys-mini-survey-question-title="true" style="display: none" class="label"><xsl:value-of select="form//question[@type = 'form.ChoicesList']/title" /></div>
    </xsl:template>
    
    <xsl:template name="mini-survey-results">
        <div class="mini-survey__results" data-ametys-mini-survey-results="true" style="display: none">
            <div data-ametys-mini-survey-chart="true"></div>        
            <xsl:call-template name="mini-survey-info"/>
            <xsl:call-template name="mini-survey-answered"/>
        </div>
    </xsl:template>
    
    <xsl:template name="mini-survey-info">
        <div data-ametys-mini-survey-info="true" class="mini-survey__votes" style="display: none">
            <span data-ametys-mini-survey-votes="true" style="display: none"></span>
            <span data-ametys-mini-survey-daysleft="true" style="display: none"></span>
        </div>
    </xsl:template>
    
    <xsl:template name="mini-survey-answered">
        <div class="mini-survey__answered" data-ametys-mini-survey-answered="true" style="display:none">
            <button class="mini-survey__answered_btn" disabled="disabled">
                <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_MINI_SURVEY_ANSWERED_BTN" i18n:catalogue="plugin.forms"/>
            </button>
        </div>
    </xsl:template>
    
    <xsl:template name="mini-survey-error">
        <div class="mini-survey__error" data-ametys-mini-survey-error="true" style="display: none">
        </div>
    </xsl:template>
    
    <xsl:template name="mini-survey-js">
        <script type="text/javascript" src="{ametys:pluginResourceURL('forms', concat('js/Chart.', ametys:lang(), '.js'))}"></script>
        <script type="text/javascript" src="{ametys:pluginResourceURL('forms', 'js/MiniSurveyHelper.js')}"></script>
        
        <script type="text/javascript">
            $j(document).ready(function() {
                MiniSurveyHelper.initialize(
                    "<xsl:value-of select="form/@id"/>", 
                    "<xsl:value-of select="$chart-type"/>", 
                    "<xsl:value-of select="$chart-width"/>", 
                    "<xsl:value-of select="$chart-height"/>", 
                    "<xsl:value-of select="$site-uri-prefix"/>",
                    <xsl:call-template name="chart-colors" />,
                    "<xsl:call-template name="chart-legend-color" />",
                    "<xsl:call-template name="chart-legend-font-family"/>",
                    <xsl:call-template name="chart-legend-font-size" />,
                    <xsl:call-template name="chart-legend-box-width" />
                );
                MiniSurveyHelper.updateFormView("<xsl:value-of select="form/@id"/>", "<xsl:value-of select="$uniqueId"/>");
            });
        </script>
    </xsl:template>
    
    <xsl:template name="chart-colors">
    {
        red: 'rgb(255, 99, 132)',
        orange: 'rgb(255, 159, 64)',
        yellow: 'rgb(255, 205, 86)',
        green: 'rgb(75, 192, 192)',
        blue: 'rgb(54, 162, 235)',
        purple: 'rgb(153, 102, 255)',
        grey: 'rgb(201, 203, 207)'
    }
    </xsl:template>
    
    <xsl:template name="chart-legend-color">#000000</xsl:template>
    <xsl:template name="chart-legend-font-family"></xsl:template>
    <xsl:template name="chart-legend-font-size">12</xsl:template>
    <xsl:template name="chart-legend-box-width">40</xsl:template>
        
</xsl:stylesheet>
