/**
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This controller allows to add an acknowledgement of receipt on submissions for current form
 * @private
 */
Ext.define('Ametys.plugins.forms.controllers.EntryReceiptController', {
	extend: 'Ametys.plugins.forms.controllers.FormController',
	
    getAdditionnalDescription: function(matchingTarget)
    {
        var isAcknowledgementActive = matchingTarget.getParameters().receiptAcknowledgement;
        this.toggle(isAcknowledgementActive);
        
        if (isAcknowledgementActive)
        {
            return "{{i18n PLUGINS_FORMS_ACKNOWLEDGEMENT_RECEIPT_ACTIVE_MSG}}";
        }
        return "";
    }
    
});
