/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Helper to select question zone into a form. Such a zone can be selected and highlighted.
 * @private
 */
Ext.define('Ametys.plugins.forms.ui.UIFormQuestion', {
	singleton: true,
	
	/**
	 * Send the form element selection
	 * @param {String} formId The form id
	 * @param {String} pageId The page id. Can be null if no page selected
     * @param {String} questionId The question id. Can be null if no question selected
	 */
    sendSelection: function(formId, pageId, questionId)
    {
        var formTool = Ametys.tool.ToolsManager.getTool("uitool-form");
        if (formTool && !formTool.hasFocus() && formTool._formId == formId)
        {
            formTool.focus();
        }
        
        var formTarget = {
            id: Ametys.message.MessageTarget.FORM_TARGET,
            parameters: {
                id: formId
            }
        };
        
        if (pageId && pageId != "")
        {
            var pageTarget = {
                id: Ametys.message.MessageTarget.FORM_PAGE,
                parameters: {
                    id: pageId,
                    formId: formId
                }
            };
            
            formTarget.subtargets = pageTarget;

            if (questionId && questionId != "")
            {
                var target = {
                    id: Ametys.message.MessageTarget.FORM_QUESTION,
                    parameters: {
                        id: questionId,
                        pageId: pageId,
                        formId: formId            
                    }
                };
                
                pageTarget.subtargets = target;
            }

            Ext.create("Ametys.message.Message", {
                type: formTool && formTool._formId == formId ? Ametys.plugins.forms.tool.FormsPreviewTool.SELECTION_PREVIEW_CHANGED : Ametys.message.Message.SELECTION_CHANGED,
                targets: [formTarget]
            });
        }
	},
	
	/**
     * Move the question
     * @param {String} pageId The page id of the question
     * @param {String} questionId The id of the question to move
     * @param {String} position The new position of the question
     */
	move: function(pageId, questionId, position)
	{
        var formTarget = Ametys.message.MessageBus.getCurrentSelectionMessage().getTarget(Ametys.message.MessageTarget.FORM_TARGET);
        if (formTarget.getParameters().form.canWrite())
        {
            Ametys.plugins.forms.dao.FormPageDAO.moveObject (
                [questionId, pageId, pageId, position],
                Ext.emptyFn,
                {scope: this, arguments: []}
            );
        }
    }
});

