<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:html="http://www.w3.org/1999/xhtml"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper" 
    xmlns:escape="org.apache.commons.lang.StringEscapeUtils"
    xmlns:forms="org.ametys.plugins.forms.xslt.FormsXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:math="http://exslt.org/math" 
    exclude-result-prefixes="docbook xlink forms resolver ametys html math">

    <xsl:template name="form-label-additionnal">
        <xsl:param name="input"/>
    </xsl:template>

    <xsl:template name="form-input-additionnal">
    </xsl:template>

    <xsl:template name="form-input-date">
        <xsl:if test="@type = 'text' and @regexptype = 'date'">
            <xsl:attribute name="type">date</xsl:attribute>
            <xsl:if test="@minvalue and @minvalue != ''">
                <xsl:attribute name="min"><xsl:value-of select="@minvalue"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="@maxvalue and @maxvalue != ''">
                <xsl:attribute name="max"><xsl:value-of select="@maxvalue"/></xsl:attribute>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="form-input-datetime">
        <xsl:if test="@type = 'text' and @regexptype = 'datetime'">
            <xsl:attribute name="type">datetime-local</xsl:attribute>
            <xsl:if test="@minvalue and @minvalue != ''">
                <xsl:attribute name="min"><xsl:value-of select="translate(@minvalue, ' ', 'T')"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="@maxvalue and @maxvalue != ''">
                <xsl:attribute name="max"><xsl:value-of select="translate(@maxvalue, ' ', 'T')"/></xsl:attribute>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <xsl:template name="form-input-time">
        <xsl:if test="@type = 'text' and @regexptype = 'time'"><xsl:attribute name="maxlength">5</xsl:attribute></xsl:if>
    </xsl:template>
    
    <xsl:template name="form-check-date">
        <xsl:param name="valueId"/>
    </xsl:template>
    <xsl:template name="form-check-datetime">
        <xsl:param name="valueId"/>
    </xsl:template>
    <xsl:template name="form-check-time">
        <xsl:param name="valueId"/>
    
        if (value_<xsl:value-of select="$valueId"/> != '')
        {
            if (!/^([012][0-9]):([012345][0-9])$/.test(value_<xsl:value-of select="$valueId"/>))
            {
                error("<xsl:value-of select="@id"/>", "text", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_TIME" i18n:catalogue="plugin.forms"/>");
            }
            else
            {
                var hours_<xsl:value-of select="$valueId"/> = parseInt(RegExp.$1);
                var minutes_<xsl:value-of select="$valueId"/> = parseInt(RegExp.$2);
                if (hours_<xsl:value-of select="$valueId"/> &gt;= 24)
                {
                    error("<xsl:value-of select="@id"/>", "text", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_TIME" i18n:catalogue="plugin.forms"/>");
                }
                else
                {
                    <xsl:if test="@minvalue and @minvalue != ''">
                        if (hours_<xsl:value-of select="$valueId"/> &lt; <xsl:value-of select="substring-before(@minvalue, ':')"/>
                            || hours_<xsl:value-of select="$valueId"/> == <xsl:value-of select="substring-before(@minvalue, ':')"/> &amp;&amp; minutes_<xsl:value-of select="$valueId"/> &lt; <xsl:value-of select="substring-after(@minvalue, ':')"/>)
                        {
                            error("<xsl:value-of select="@id"/>", "text", "<i18n:translate><i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_TIME_MINVALUE" i18n:catalogue="plugin.forms"/><i18n:param><xsl:value-of select="@minvalue"/></i18n:param></i18n:translate>");
                        } 
                    </xsl:if>
                    <xsl:if test="@maxvalue and @maxvalue != ''">
                        if (hours_<xsl:value-of select="$valueId"/> &gt; <xsl:value-of select="substring-before(@maxvalue, ':')"/>
                            || hours_<xsl:value-of select="$valueId"/> == <xsl:value-of select="substring-before(@maxvalue, ':')"/> &amp;&amp; minutes_<xsl:value-of select="$valueId"/> &gt; <xsl:value-of select="substring-after(@maxvalue, ':')"/>)
                        {
                            error("<xsl:value-of select="@id"/>", "text", "<i18n:translate><i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_TIME_MAXVALUE" i18n:catalogue="plugin.forms"/><i18n:param><xsl:value-of select="@maxvalue"/></i18n:param></i18n:translate>");
                        } 
                    </xsl:if>
                }
            }
        }
    </xsl:template>
        
</xsl:stylesheet>
