<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    exclude-result-prefixes="ametys">
    
    <xsl:import href="view:forms://stylesheets/forms/helper/entry-information.xsl"/>

    <xsl:param name="contextPath"/>
    
    <xsl:variable name="cssPrefix">entry-form-properties</xsl:variable>

    <xsl:template match="/entry">
        <xml>
	        <div class="{$cssPrefix}">
	            <xsl:call-template name="entry-card" />
	            <br/>
	            <xsl:if test="@entryId">
		            <div class="{$cssPrefix}__item">
			            <div class="{$cssPrefix}__item_label"><strong><i18n:text i18n:catalogue="plugin.forms" i18n:key="PLUGIN_FORMS_MODEL_ITEM_ID_LABEL"/></strong></div>   
			            <div class="{$cssPrefix}__item_value {translate('STRING', $uppercase, $lowercase)}"><xsl:value-of select="@entryId" /></div>    
			        </div>
	            </xsl:if>
   	            <xsl:apply-templates select="field"/>
	        </div>
        </xml>
    </xsl:template>
    
    <xsl:template match="field">
        <div class="{$cssPrefix}__item">
            <xsl:apply-templates select="." mode="display-label"/>   
            <xsl:apply-templates select="." mode="display-value"/>    
        </div>
    </xsl:template>
    
    <xsl:template match="field" mode="display-label">
        <div class="{$cssPrefix}__item_label">
            <strong><xsl:value-of select="@label"/></strong>
        </div>
    </xsl:template>

    <xsl:template match="field" mode="display-value">
        <div class="{$cssPrefix}__item_value {translate(@type, $uppercase, $lowercase)}">
            <xsl:choose>
                <xsl:when test="value">
                    <xsl:apply-templates select="." mode="value"/>    
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_EMPTY_VALUE" i18n:catalogue="plugin.forms"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template match="field[@typeId='form.ChoicesList']" mode="display-value">
        <div class="{$cssPrefix}__item_value {translate(@type, $uppercase, $lowercase)}">
            <xsl:choose>
                <xsl:when test="additional-infos/values/value">
                    <xsl:apply-templates select="." mode="value"/>    
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_EMPTY_VALUE" i18n:catalogue="plugin.forms"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="entry-card">
        <div class="details-view-card">
            <p>
                <span class="title"><i18n:text i18n:catalogue="plugin.forms" i18n:key="PLUGINS_FORMS_ENTRY_PROPERTIES_FORM"/><xsl:text>&#160;</xsl:text></span>
                <span><xsl:value-of select="@label"/></span>
            </p>    
            <p>
                <span>
                    <span class="title"><i18n:text i18n:catalogue="plugin.cms" i18n:key="UITOOL_DETAILS_CONTENT_ID"/><xsl:text>&#160;</xsl:text></span>
                    <button class="copy-button" title="plugin.cms:UITOOL_DETAILS_CONTENT_COPY_ID_HINT" i18n:attr="title" type="button" onclick="javascript:Ametys.plugins.cms.content.tool.PropertiesTool.copyToClipboard(this, '{content/@id}')">
                       <span class="ametysicon-document28" ></span>
                    </button>    
                    <xsl:choose>
                        <xsl:when test="@access = 'true'">
                           <a href="javascript:void(0)" onclick="Ametys.openWorkspaceTool('repository', 'uitool-repository-ametysobject-metadata', {{id: '{@id}'}})">
                               <span><xsl:value-of select="@id"/></span>
                           </a>
                       </xsl:when>
                        <xsl:otherwise><span><xsl:value-of select="@id"/></span></xsl:otherwise>
                    </xsl:choose>
                </span>
            </p>    
            <p>
                <span>
                    <span class="title"><i18n:text i18n:catalogue="plugin.cms" i18n:key="UITOOL_DETAILS_CONTENT_UUID"/><xsl:text>&#160;&#160;</xsl:text></span>
                    <button class="copy-button" title="plugin.cms:UITOOL_DETAILS_CONTENT_COPY_UUID_HINT" i18n:attr="title" type="button" onclick="javascript:Ametys.plugins.cms.content.tool.PropertiesTool.copyToClipboard(this, '{@uuid}')">
                       <span class="ametysicon-document28" ></span>
                    </button>
                    <xsl:choose>
                        <xsl:when test="@access = 'true'">
                          <a href="javascript:void(0)" onclick="Ametys.openWorkspaceTool('repository', 'uitool-repository-nodeproperties', {{id : '{@uuid}', workspaceName: 'default', path: '{@path}'}})">
                              <span><xsl:value-of select="@uuid"/></span>
                          </a>
                      </xsl:when>
                        <xsl:otherwise><span><xsl:value-of select="@uuid"/></span></xsl:otherwise>
                    </xsl:choose>
                </span>
            </p>
            
            <xsl:if test="@workflow">
	            <p>
	                <span class="title"><i18n:text i18n:catalogue="plugin.cms" i18n:key="UITOOL_DETAILS_CONTENT_WORKFLOW_STEP"/><xsl:text>&#160;&#160;</xsl:text></span>
	                <span style="background: url('{$contextPath}{@icon}') left center no-repeat; padding-left: 20px; line-height: 16px; display: inline-block;"><xsl:value-of select="@workflow"/></span>
	            </p>
            </xsl:if>
            
            <xsl:if test="@user">
	            <p>
	                <span class="title"><i18n:text i18n:catalogue="plugin.forms" i18n:key="PLUGINS_FORMS_ENTRY_PROPERTIES_USER"/><xsl:text>&#160;</xsl:text></span>
	                <span><xsl:value-of select="@user"/></span>
	            </p>
            </xsl:if>
            
            <p>
                <span class="title"><i18n:text i18n:catalogue="plugin.forms" i18n:key="PLUGINS_FORMS_ENTRY_PROPERTIES_CREATION_DATE"/><xsl:text>&#160;</xsl:text></span>
                <span><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{@creationDate}"/></span>
            </p>
            
            <xsl:call-template name="input-text-clipboard"/>
        </div>
    </xsl:template>
    
    <xsl:template name="input-text-clipboard">
       <input type="text" id="input-text-clipboard" value="" style="opacity: 0; position: absolute; top: -1000px;" />
    </xsl:template>
   
    <xsl:template match="field[@typeId='form.Computed' and additional-infos/@computed-type = 'computing.CurrentPageId']" mode="value">
        <a href="#" onclick="Ametys.tool.ToolsManager.openTool('uitool-page', {{'id':'{additional-infos/page/id}'}}); return false;"><xsl:value-of select="additional-infos/page/title"/></a>
    </xsl:template>
</xsl:stylesheet>