/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.actions;

import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;

import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Sets the Content-Disposition header as attachment and injects the form title as the attachment filename.
 */
public class SetFormHeaderAction extends ServiceableAction
{
    
    /** The ametys object resolver. */
    protected AmetysObjectResolver _resolver;
    
    /** I18n Utils */
    protected I18nUtils _i18nUtils;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _resolver = (AmetysObjectResolver) serviceManager.lookup(AmetysObjectResolver.ROLE);
        _i18nUtils = (I18nUtils) serviceManager.lookup(I18nUtils.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        Response response = ObjectModelHelper.getResponse(objectModel);
        
        String formId = parameters.getParameter("formId", request.getParameter("formId"));
        String summary = parameters.getParameter("summary", request.getParameter("summary"));
        String suffix = parameters.getParameter("suffix", request.getParameter("suffix"));
        
        Form form = _resolver.resolveById(formId);
        
        String title = form.getTitle();
        if (StringUtils.isEmpty(title))
        {
            title = form.getName();
        }
        
        if (summary.equals("true"))
        {
            title += "_" + _i18nUtils.translate(new I18nizableText("plugin.forms", "PLUGINS_FORMS_EXPORT_SUMMARY_SUFFIX"));
        }
        
        response.setHeader("Content-Disposition", "attachment; filename=\"" + title + suffix + "\"");
        
        return EMPTY_MAP;
    }

}
